/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.restclient;

import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.DeleteVersionWithCustomFieldParameters;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.testkit.client.restclient.Version;
import com.atlassian.jira.testkit.client.restclient.VersionIssueCounts;
import com.atlassian.jira.testkit.client.restclient.VersionMove;
import com.atlassian.jira.testkit.client.restclient.VersionUnresolvedIssueCount;
import java.net.URI;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public class VersionClient
extends RestApiClient<VersionClient> {
    public VersionClient(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public Version get(String versionID) throws WebApplicationException {
        return (Version)this.versionWithID(versionID).request().get(Version.class);
    }

    public ParsedResponse getResponse(String versionID) {
        return this.toResponse(() -> (Response)this.versionWithID(versionID).request().get(Response.class));
    }

    public Version create(Version version) throws WebApplicationException {
        return (Version)this.version().post(Entity.json((Object)version), Version.class);
    }

    public ParsedResponse createResponse(Version version) {
        return this.toResponse(() -> (Response)this.version().post(Entity.json((Object)version), Response.class));
    }

    public ParsedResponse delete(String versionId) throws WebApplicationException {
        return this.delete(versionId, null, null);
    }

    public ParsedResponse delete(String versionId, URI swapFixVersion, URI swapAffectedVersion) throws WebApplicationException {
        return this.toResponse(() -> {
            WebTarget deleteResource = this.versionWithID(versionId);
            if (swapFixVersion != null) {
                deleteResource = deleteResource.queryParam("moveFixIssuesTo", new Object[]{swapFixVersion.getPath()});
            }
            if (swapAffectedVersion != null) {
                deleteResource = deleteResource.queryParam("moveAffectedIssuesTo", new Object[]{swapAffectedVersion.getPath()});
            }
            return (Response)deleteResource.request().delete(Response.class);
        });
    }

    public ParsedResponse deleteVersionAndSwap(String versionId, DeleteVersionWithCustomFieldParameters parameters) throws WebApplicationException {
        return this.toResponse(() -> {
            WebTarget removeAndSwapResource = this.versionWithID(versionId).path("removeAndSwap");
            return (Response)removeAndSwapResource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)parameters), Response.class);
        });
    }

    public ParsedResponse merge(String versionId, String mergeToVersionId) throws WebApplicationException {
        return this.toResponse(() -> {
            WebTarget mergeResource = this.versionWithID(versionId).path("mergeto").path(mergeToVersionId);
            return (Response)mergeResource.request().put(null, Response.class);
        });
    }

    public Version move(String versionId, VersionMove versionMove) throws WebApplicationException {
        return (Version)this.versionMove(versionId).post(Entity.json((Object)versionMove), Version.class);
    }

    public ParsedResponse moveResponse(String versionId, VersionMove versionMove) {
        return this.toResponse(() -> (Response)this.versionMove(versionId).post(Entity.json((Object)versionMove), Response.class));
    }

    public Version archive(String versionID) {
        return (Version)this.versionWithID(versionID).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.json((Object)new Version().archived(true)), Version.class);
    }

    public Version unarchive(String versionID) {
        return (Version)this.versionWithID(versionID).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.json((Object)new Version().archived(false)), Version.class);
    }

    public Version release(String versionID) {
        return (Version)this.versionWithID(versionID).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.json((Object)new Version().released(true)), Version.class);
    }

    public Version unrelease(String versionID) {
        return (Version)this.versionWithID(versionID).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.json((Object)new Version().released(false)), Version.class);
    }

    public VersionIssueCounts getVersionIssueCounts(String versionID) throws WebApplicationException {
        return (VersionIssueCounts)this.versionWithID(versionID).path("relatedIssueCounts").request().get(VersionIssueCounts.class);
    }

    public ParsedResponse getVersionIssueCountsResponse(String versionId) {
        return this.toResponse(() -> (Response)this.versionWithID(versionId).path("relatedIssueCounts").request().get(Response.class));
    }

    public VersionUnresolvedIssueCount getVersionUnresolvedIssueCount(String versionID) throws WebApplicationException {
        return (VersionUnresolvedIssueCount)this.versionWithID(versionID).path("unresolvedIssueCount").request().get(VersionUnresolvedIssueCount.class);
    }

    public ParsedResponse getVersionUnresolvedIssueCountResponse(String versionId) {
        return this.toResponse(() -> (Response)this.versionWithID(versionId).path("unresolvedIssueCount").request().get(Response.class));
    }

    public ParsedResponse putResponse(String versionId, Version version) {
        return this.toResponse(() -> (Response)this.versionWithID(versionId).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.json((Object)version), Response.class));
    }

    public ParsedResponse putResponse(Version version) {
        String[] selfParts = version.self.split("/");
        String versionId = selfParts[selfParts.length - 1];
        return this.putResponse(versionId, version);
    }

    private WebTarget versionWithID(String versionID) {
        return this.createResource().path("version").path(versionID);
    }

    private Invocation.Builder version() {
        return this.createResource().path("version").request(new String[]{"application/json"});
    }

    private Invocation.Builder versionMove(String versionID) {
        return this.createResource().path("version").path(versionID).path("move").request(new String[]{"application/json"});
    }
}

