/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.restclient;

import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.testkit.client.restclient.Watches;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public class WatchersClient
extends RestApiClient<WatchersClient> {
    public WatchersClient(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public Watches get(String issueKey) throws WebApplicationException {
        return (Watches)this.watchersForIssueWithKey(issueKey).request().get(Watches.class);
    }

    public ParsedResponse getResponse(String issueKey) {
        return this.toResponse(() -> (Response)this.watchersForIssueWithKey(issueKey).request().get(Response.class));
    }

    public ParsedResponse postResponse(String issueKey, String username) {
        return this.toResponse(() -> (Response)this.watchersForIssueWithKey(issueKey).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(username == null ? null : Entity.json((Object)String.format("\"%s\"", username)), Response.class));
    }

    public ParsedResponse deleteResponse(String issueKey, String username) {
        return this.toResponse(() -> (Response)this.watchersForIssueWithKey(issueKey).queryParam("username", new Object[]{username}).request().delete(Response.class));
    }

    private WebTarget watchersForIssueWithKey(String issueKey) {
        return this.createResource().path("issue").path(issueKey).path("watchers");
    }
}

