/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.restclient;

import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.testkit.client.restclient.Worklog;
import com.atlassian.jira.testkit.client.restclient.WorklogChangedSinceBean;
import com.atlassian.jira.testkit.client.restclient.WorklogWithPaginationBean;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public class WorklogClient
extends RestApiClient<WorklogClient> {
    public WorklogClient(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public WorklogWithPaginationBean getAll(String issueKey) {
        return (WorklogWithPaginationBean)this.createResource().path("issue").path(issueKey).path("worklog").request().get(WorklogWithPaginationBean.class);
    }

    public Worklog get(String issueKey, String worklogID) throws WebApplicationException {
        return (Worklog)this.worklogWithID(issueKey, worklogID).request().get(Worklog.class);
    }

    public ParsedResponse getResponse(String issueKey, String worklogID) {
        return this.toResponse(() -> (Response)this.worklogWithID(issueKey, worklogID).request().get(Response.class));
    }

    protected WebTarget worklogWithID(String issueKey, String worklogID) {
        return this.createResource().path("issue").path(issueKey).path("worklog").path(worklogID);
    }

    public ParsedResponse<Worklog> put(String issueKey, Worklog worklog) {
        return this.toResponse(() -> (Response)this.createResource().path("issue").path(issueKey).path("worklog").path(worklog.id).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.json((Object)worklog), Response.class), Worklog.class);
    }

    public ParsedResponse<Worklog> put(String issueKey, Worklog worklog, Map<String, String> queryParams) {
        return this.toResponse(() -> {
            WebTarget path = this.createResource().path("issue").path(issueKey).path("worklog").path(worklog.id);
            for (Map.Entry entry : queryParams.entrySet()) {
                path = path.queryParam((String)entry.getKey(), new Object[]{entry.getValue()});
            }
            return (Response)path.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.json((Object)worklog), Response.class);
        }, Worklog.class);
    }

    public ParsedResponse<Worklog> post(String issueKey, Worklog worklog) {
        return this.toResponse(() -> (Response)this.createResource().path("issue").path(issueKey).path("worklog").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)worklog), Response.class), Worklog.class);
    }

    public ParsedResponse<Worklog> post(String issueKey, Worklog worklog, Map<String, String> queryParams) {
        return this.toResponse(() -> {
            WebTarget path = this.createResource().path("issue").path(issueKey).path("worklog");
            for (Map.Entry entry : queryParams.entrySet()) {
                path = path.queryParam((String)entry.getKey(), new Object[]{entry.getValue()});
            }
            return (Response)path.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)worklog), Response.class);
        }, Worklog.class);
    }

    public ParsedResponse delete(String issueKey, Worklog worklog) {
        return this.toResponse(() -> (Response)this.createResource().path("issue").path(issueKey).path("worklog").path(worklog.id).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).delete(Response.class));
    }

    public ParsedResponse delete(String issueKey, Worklog worklog, Map<String, String> queryParams) {
        return this.toResponse(() -> {
            WebTarget path = this.createResource().path("issue").path(issueKey).path("worklog").path(worklog.id);
            for (Map.Entry entry : queryParams.entrySet()) {
                path = path.queryParam((String)entry.getKey(), new Object[]{entry.getValue()});
            }
            return (Response)path.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).delete(Response.class);
        });
    }

    public ParsedResponse<WorklogChangedSinceBean> getUpdatedWorklogsSince(Long since) {
        return this.toResponse(() -> (Response)this.createResource().path("worklog").path("updated").queryParam("since", new Object[]{String.valueOf(since)}).request().get(Response.class), WorklogChangedSinceBean.class);
    }

    public ParsedResponse<WorklogChangedSinceBean> getDeletedWorklogsSince(Long since) {
        return this.toResponse(() -> (Response)this.createResource().path("worklog").path("deleted").queryParam("since", new Object[]{String.valueOf(since)}).request().get(Response.class), WorklogChangedSinceBean.class);
    }

    public ParsedResponse<List<Worklog>> getWorklogs(Collection<Long> ids) {
        return this.toResponse(() -> (Response)this.createResource().path("worklog").path("list").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)new WorklogIdsRequestBean(ids)), Response.class), new GenericType<List<Worklog>>(){});
    }

    public class WorklogIdsRequestBean {
        private Collection<Long> ids;

        public WorklogIdsRequestBean() {
        }

        public WorklogIdsRequestBean(Collection<Long> ids) {
            this.ids = ids;
        }

        public Collection<Long> getIds() {
            return this.ids;
        }

        public void setIds(Set<Long> ids) {
            this.ids = ids;
        }
    }
}

