/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.util;

import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.jira.testkit.client.log.FuncTestOut;
import com.atlassian.jira.testkit.client.util.AbstractEnvironmentData;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;

public class TestKitLocalEnvironmentData
extends AbstractEnvironmentData {
    private static final String DEFAULT_PROTOCOL = "http";
    private static final String DEFAULT_HOST = "localhost";
    private static final String DEFAULT_PORT = "2990";
    private static final String DEFAULT_CONTEXT = "/jira";
    private static final String DEFAULT_EDITION = "standard";
    private static final String DEFAULT_XML_DATA_LOCATION = "./src/test/xml";
    private static final String DEFAULT_PROPERTIES_FILENAME = "localtest.properties";
    private static final String DEFAULT_CREATE_DUMMY_TENANT = "false";
    private static final String JIRA_PROTOCOL = "jira.protocol";
    private static final String JIRA_HOST = "jira.host";
    private static final String JIRA_PORT = "jira.port";
    private static final String JIRA_XML_DATA_LOCATION = "jira.xml.data.location";
    private static final String JIRA_CONTEXT = "jira.context";
    private static final String JIRA_TENANT = "jira.tenant";
    private static final String JIRA_EDITION = "jira.edition";
    private static final String CREATE_DUMMY_TENANT = "jira.create.dummy.tenant";
    private static final String TEST_SERVER_PROPERTIES = "test.server.properties";
    private final String contextPath = this.getEnvironmentProperty("jira.context", "/jira");
    private final String tenant;
    private final boolean shouldCreateDummyTenant;
    private final URL baseUrl;
    private final File xmlDataLocation;
    private final String edition;

    public TestKitLocalEnvironmentData() {
        this(TestKitLocalEnvironmentData.loadProperties(TEST_SERVER_PROPERTIES, DEFAULT_PROPERTIES_FILENAME), null);
    }

    public TestKitLocalEnvironmentData(String xmlDataLocation) {
        this(TestKitLocalEnvironmentData.loadProperties(TEST_SERVER_PROPERTIES, DEFAULT_PROPERTIES_FILENAME), xmlDataLocation);
    }

    public TestKitLocalEnvironmentData(Properties properties, @Nullable String xmlDataLocationOverride) {
        super(properties);
        String xmlDataLocationProperty = this.getEnvironmentProperty(JIRA_XML_DATA_LOCATION, DEFAULT_XML_DATA_LOCATION).trim();
        this.xmlDataLocation = TestKitLocalEnvironmentData.resolveXmlDataLocation(xmlDataLocationOverride, xmlDataLocationProperty);
        String protocol = this.getEnvironmentProperty(JIRA_PROTOCOL, DEFAULT_PROTOCOL);
        String host = this.getEnvironmentProperty(JIRA_HOST, DEFAULT_HOST);
        String port = this.getEnvironmentProperty(JIRA_PORT, DEFAULT_PORT);
        this.baseUrl = TestKitLocalEnvironmentData.constructBaseUrl(protocol, host, port, this.contextPath);
        this.tenant = this.getEnvironmentProperty(JIRA_TENANT, null);
        this.shouldCreateDummyTenant = Boolean.parseBoolean(this.getEnvironmentProperty(CREATE_DUMMY_TENANT, DEFAULT_CREATE_DUMMY_TENANT));
        this.edition = this.getEnvironmentProperty(JIRA_EDITION, DEFAULT_EDITION);
    }

    private static URL constructBaseUrl(String protocol, String host, String port, String contextPath) {
        String baseUrl = protocol + "://" + host + ":" + port + contextPath;
        try {
            return new URL(baseUrl);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Malformed URL " + baseUrl);
        }
    }

    private static File resolveXmlDataLocation(String xmlDataLocationOverride, String xmlDataLocationProperty) {
        File unresolvedLocation = new File(xmlDataLocationOverride != null ? xmlDataLocationOverride : xmlDataLocationProperty);
        try {
            File canonicalLocation = unresolvedLocation.getCanonicalFile();
            if (!canonicalLocation.exists()) {
                throw new RuntimeException(String.format("Cannot find xml data location: '%s'", unresolvedLocation));
            }
            return canonicalLocation;
        }
        catch (IOException e) {
            throw new RuntimeException("IOException trying to resolve file " + unresolvedLocation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(String key, String def) {
        Properties properties;
        Properties properties2 = new Properties();
        String propertiesFileName = "";
        propertiesFileName = System.getProperty(key, def);
        InputStream propStream = ClassLoaderUtils.getResourceAsStream((String)propertiesFileName, TestKitLocalEnvironmentData.class);
        if (propStream == null) {
            propStream = new FileInputStream(propertiesFileName);
        }
        try {
            properties2.load(propStream);
            properties = properties2;
        }
        catch (Throwable throwable) {
            try {
                IOUtils.closeQuietly((InputStream)propStream);
                throw throwable;
            }
            catch (IOException e) {
                FuncTestOut.out.println("Cannot load file " + propertiesFileName + " from CLASSPATH.");
                e.printStackTrace(FuncTestOut.out);
                throw new IllegalArgumentException("Could not load properties file " + propertiesFileName + " from classpath");
            }
        }
        IOUtils.closeQuietly((InputStream)propStream);
        return properties;
    }

    @Override
    public String getContext() {
        return this.contextPath;
    }

    @Override
    public String getTenant() {
        return this.tenant;
    }

    @Override
    public boolean shouldCreateDummyTenant() {
        return this.shouldCreateDummyTenant;
    }

    @Override
    public URL getBaseUrl() {
        return this.baseUrl;
    }

    @Override
    public File getXMLDataLocation() {
        return this.xmlDataLocation;
    }

    @Override
    public File getWorkingDirectory() {
        File file = new File(System.getProperty("java.io.tmpdir"), "jira_autotest");
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Could not create JIRA home dir " + file);
        }
    }

    @Override
    public File getJIRAHomeLocation() {
        return this.getWorkingDirectory();
    }

    @Override
    public String getEdition() {
        return this.edition;
    }
}

