/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client;

import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.google.common.collect.Sets;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.util.Set;

public class CurrentUserPreferencesClient
extends RestApiClient<CurrentUserPreferencesClient> {
    private static final String PREFERENCES_PATH = "mypreferences";
    private static final String KEY = "key";
    private Set<ClientResponse> responses = Sets.newHashSet();

    public CurrentUserPreferencesClient(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public ClientResponse getPreference(String key) {
        WebResource webResource = this.createResource().path(PREFERENCES_PATH);
        if (key != null) {
            webResource = webResource.queryParam(KEY, key);
        }
        ClientResponse clientResponse = (ClientResponse)webResource.get(ClientResponse.class);
        this.responses.add(clientResponse);
        return clientResponse;
    }

    public ClientResponse setPreference(String key, String value) {
        WebResource webResource = this.createResource().path(PREFERENCES_PATH);
        if (key != null) {
            webResource = webResource.queryParam(KEY, key);
        }
        ClientResponse put = (ClientResponse)webResource.type("application/json").put(ClientResponse.class, (Object)value);
        this.responses.add(put);
        return put;
    }

    public ClientResponse removePreference(String key) {
        WebResource webResource = this.createResource().path(PREFERENCES_PATH);
        if (key != null) {
            webResource = webResource.queryParam(KEY, key);
        }
        ClientResponse delete = (ClientResponse)webResource.delete(ClientResponse.class);
        this.responses.add(delete);
        return delete;
    }

    public void close() {
        for (ClientResponse response : this.responses) {
            response.close();
        }
    }
}

