/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client;

import com.atlassian.jira.testkit.beans.CustomFieldRequest;
import com.atlassian.jira.testkit.beans.CustomFieldResponse;
import com.atlassian.jira.testkit.client.BackdoorControl;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.sun.jersey.api.client.GenericType;
import java.util.List;

public class CustomFieldsControl
extends BackdoorControl<CustomFieldsControl> {
    public CustomFieldsControl(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public String createCustomField(String name, String description, String type, String searcherKey) {
        CustomFieldRequest request = new CustomFieldRequest();
        request.name = name;
        request.description = description;
        request.type = type;
        request.searcherKey = searcherKey;
        CustomFieldResponse response = (CustomFieldResponse)this.createResource().path("customFields/create").post(CustomFieldResponse.class, (Object)request);
        return response.id;
    }

    public void updateCustomField(String id, String name, String description, String searcherKey) {
        CustomFieldRequest request = new CustomFieldRequest();
        request.name = name;
        request.description = description;
        request.searcherKey = searcherKey;
        this.createResource().path("customFields").path(id).put((Object)request);
    }

    public void deleteCustomField(String customFieldId) {
        this.createResource().path("customFields").path("delete").path(customFieldId).delete();
    }

    public void addOption(String customFieldId, String optionValue) {
        this.createResource().path("customFields/addOption").path(customFieldId).post((Object)optionValue);
    }

    public void deleteOption(String customFieldId, String optionValue) {
        this.createResource().path("customFields/deleteOption").path(customFieldId).delete((Object)optionValue);
    }

    public List<CustomFieldResponse> getCustomFields() {
        return this.getCustomFields(false);
    }

    public List<CustomFieldResponse> getCustomFields(boolean config) {
        return (List)this.createResource().path("customFields").path("get").queryParam("config", String.valueOf(config)).get((GenericType)new GenericType<List<CustomFieldResponse>>(){});
    }
}

