/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client;

import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.jerseyclient.ApacheClientFactoryImpl;
import com.atlassian.jira.testkit.client.restclient.Errors;
import com.atlassian.jira.testkit.client.restclient.Response;
import com.google.common.collect.Sets;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.LoggingFilter;
import com.sun.jersey.multipart.impl.MultiPartWriter;
import java.util.EnumSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.jaxrs.JacksonJaxbJsonProvider;
import org.codehaus.jackson.map.DeserializationConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RestApiClient<T extends RestApiClient<T>> {
    private static final Logger log = LoggerFactory.getLogger(RestApiClient.class);
    public static final String REST_VERSION = "2";
    private static ThreadLocal<Client> client = new ThreadLocal<Client>(){

        @Override
        protected Client initialValue() {
            DefaultClientConfig config = new DefaultClientConfig();
            JacksonJaxbJsonProvider jacksonProvider = new JacksonJaxbJsonProvider();
            jacksonProvider.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            config.getSingletons().add(jacksonProvider);
            config.getClasses().add(MultiPartWriter.class);
            ApacheClientFactoryImpl clientFactory = new ApacheClientFactoryImpl((ClientConfig)config);
            Client client = clientFactory.create();
            if (log.isDebugEnabled()) {
                client.addFilter((ClientFilter)new LoggingFilter());
            }
            return client;
        }
    };
    private final JIRAEnvironmentData environmentData;
    protected String loginAs;
    protected String loginPassword;
    private final Set<ClientResponse> responses;
    private String version;

    protected RestApiClient(JIRAEnvironmentData environmentData) {
        this(environmentData, REST_VERSION);
    }

    protected RestApiClient(JIRAEnvironmentData environmentData, String version) {
        this.loginPassword = this.loginAs = "admin";
        this.responses = Sets.newHashSet();
        this.environmentData = environmentData;
        this.version = version;
    }

    public T anonymous() {
        this.loginAs = null;
        this.loginPassword = null;
        return (T)this;
    }

    public T loginAs(String username) {
        return this.loginAs(username, username);
    }

    public T loginAs(String username, String password) {
        this.loginAs = username;
        this.loginPassword = password;
        return (T)this;
    }

    @Nonnull
    public JIRAEnvironmentData getEnvironmentData() {
        return this.environmentData;
    }

    protected WebResource createResource() {
        return this.resourceRoot(this.environmentData.getBaseUrl().toExternalForm()).path("rest").path("api").path(this.version);
    }

    protected WebResource createResourceInternal() {
        return this.resourceRoot(this.environmentData.getBaseUrl().toExternalForm()).path("rest").path("internal").path("1.0");
    }

    protected WebResource createResourceGadget() {
        return this.resourceRoot(this.environmentData.getBaseUrl().toExternalForm()).path("rest").path("gadget").path("1.0");
    }

    protected WebResource resourceRoot(String url) {
        WebResource resource = this.client().resource(url);
        if (this.loginAs != null) {
            resource = resource.queryParam("os_authType", "basic").queryParam("os_username", RestApiClient.percentEncode(this.loginAs)).queryParam("os_password", RestApiClient.percentEncode(this.loginPassword));
        }
        return resource;
    }

    protected final Client client() {
        return client.get();
    }

    protected Response<?> toResponse(Method method) {
        ClientResponse clientResponse = this.registerResponse(method.call());
        if (clientResponse.getStatus() == 200) {
            Response response = new Response(clientResponse.getStatus(), null);
            clientResponse.close();
            return response;
        }
        return this.errorResponse(clientResponse);
    }

    protected <T> Response<T> toResponse(Method method, Class<T> clazz) {
        return this.toResponse(method, new GenericType(clazz));
    }

    protected <T> Response<T> toResponse(Method method, GenericType<T> clazz) {
        ClientResponse clientResponse = this.registerResponse(method.call());
        if (clientResponse.getStatus() < 300) {
            Object object = null;
            if (clientResponse.hasEntity()) {
                object = clientResponse.getEntity(clazz);
            }
            Response<Object> tResponse = new Response<Object>(clientResponse.getStatus(), null, object);
            clientResponse.close();
            return tResponse;
        }
        return this.errorResponse(clientResponse);
    }

    protected <T> Response<T> errorResponse(ClientResponse clientResponse) {
        Errors entity = null;
        if (clientResponse.hasEntity() && MediaType.APPLICATION_JSON_TYPE.isCompatible(clientResponse.getType())) {
            try {
                entity = (Errors)clientResponse.getEntity(Errors.class);
            }
            catch (Exception e) {
                log.debug("Failed to deserialise Errors from response", (Throwable)e);
            }
        }
        Response response = new Response(clientResponse.getStatus(), entity);
        clientResponse.close();
        return response;
    }

    protected WebResource expanded(WebResource resource, EnumSet<?> expands) {
        if (expands.isEmpty()) {
            return resource;
        }
        return resource.queryParam("expand", RestApiClient.percentEncode(StringUtils.join(expands, (String)",")));
    }

    protected ClientResponse registerResponse(ClientResponse response) {
        this.responses.add(response);
        return response;
    }

    public void cleanUp() {
        for (ClientResponse respnse : this.responses) {
            respnse.close();
        }
        this.responses.clear();
    }

    protected static <E extends Enum<E>> EnumSet<E> setOf(Class<E> cls, E ... expand) {
        return expand.length == 0 ? EnumSet.noneOf(cls) : EnumSet.of(expand[0], expand);
    }

    protected static String percentEncode(String queryParam) {
        return queryParam == null ? null : queryParam.replace("%", "%25");
    }

    public static interface Method {
        public ClientResponse call();
    }
}

