/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client;

import com.atlassian.jira.testkit.beans.DirectoryDTO;
import com.atlassian.jira.testkit.beans.LoginInfoBean;
import com.atlassian.jira.testkit.beans.UserDTO;
import com.atlassian.jira.testkit.client.BackdoorControl;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.sun.jersey.api.client.WebResource;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import javax.ws.rs.core.MediaType;

public class UsersAndGroupsControl
extends BackdoorControl<UsersAndGroupsControl> {
    public UsersAndGroupsControl(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public UsersAndGroupsControl addUser(String username) {
        this.addUser(username, username, username, username + "@example.com");
        return this;
    }

    public UsersAndGroupsControl addUser(String username, String password, String displayName, String email) {
        this.addUser(username, password, displayName, email, false);
        return this;
    }

    public UsersAndGroupsControl addUser(String username, String password, String displayName, String email, boolean sendEmail) {
        this.get(this.createResource().path("user").path("add").queryParam("userName", username).queryParam("password", password).queryParam("displayName", displayName).queryParam("email", email).queryParam("sendEmail", "" + sendEmail));
        return this;
    }

    public UsersAndGroupsControl addUserEvenIfUserExists(String username) {
        this.addUserEvenIfUserExists(username, username, username, username + "@example.com");
        return this;
    }

    public UsersAndGroupsControl addUserEvenIfUserExists(String username, String password, String displayName, String email) {
        this.addUserEvenIfUserExists(username, password, displayName, email, false);
        return this;
    }

    public UsersAndGroupsControl addUserEvenIfUserExists(String username, String password, String displayName, String email, boolean sendEmail) {
        this.get(this.createResource().path("user").path("addEvenIfUserExists").queryParam("userName", username).queryParam("password", password).queryParam("displayName", displayName).queryParam("email", email).queryParam("sendEmail", "" + sendEmail));
        return this;
    }

    public UsersAndGroupsControl addUsers(String usernamePrefix, String displayNamePrefix, int numberOfNewUsers) {
        this.get(this.createResource().path("user").path("addMany").queryParam("usernamePrefix", usernamePrefix).queryParam("displayNamePrefix", displayNamePrefix).queryParam("numberOfNewUsers", "" + numberOfNewUsers));
        return this;
    }

    public void addUsersWithGroup(String usernamePrefix, String displayNamePrefix, int numberOfNewUsers, String groupName) {
        this.get(this.createResource().path("user").path("addMany").queryParam("usernamePrefix", usernamePrefix).queryParam("displayNamePrefix", displayNamePrefix).queryParam("numberOfNewUsers", "" + numberOfNewUsers).queryParam("groupName", groupName));
    }

    public void deleteUser(String username) {
        this.get(this.createResource().path("user").path("delete").queryParam("userName", username));
    }

    public boolean userExists(String username) {
        return (Boolean)this.createResource().path("user").path("exists").queryParam("userName", username).get(Boolean.class);
    }

    public boolean isUserInGroup(String username, String groupName) {
        return (Boolean)this.createResource().path("group").path("includes").queryParam("userName", username).queryParam("groupName", groupName).get(Boolean.class);
    }

    public void addUserToGroup(String username, String groupName) {
        this.get(this.createResource().path("user").path("addToGroup").queryParam("userName", username).queryParam("groupName", groupName));
    }

    public void removeUserFromGroup(String username, String groupName) {
        this.get(this.createResource().path("user").path("removeFromGroup").queryParam("userName", username).queryParam("groupName", groupName));
    }

    public void addGroup(String groupName) {
        this.get(this.createResource().path("group").path("add").queryParam("groupName", groupName));
    }

    public boolean groupExists(String groupName) {
        return Boolean.parseBoolean(this.get(this.createResource().path("group").path("exists").queryParam("groupName", groupName)));
    }

    public UsersAndGroupsControl deleteGroup(String groupName) {
        this.get(this.createResource().path("group").path("delete").queryParam("groupName", groupName));
        return this;
    }

    public void addGroupToGroup(String childGroupName, String parentGroupName) {
        this.get(this.createResource().path("group").path("addToGroup").queryParam("groupName", childGroupName).queryParam("parentGroupName", parentGroupName));
    }

    public UsersAndGroupsControl addGroups(String groupNamePrefix, int numberOfNewGroups, @Nullable String parentGroupName, int numberOfNewUsersPerGroup) {
        this.get(this.createResource().path("group").path("addMany").queryParam("groupNamePrefix", groupNamePrefix).queryParam("numberOfNewGroups", "" + numberOfNewGroups).queryParam("parentGroupName", parentGroupName).queryParam("numberOfNewUsersPerGroup", "" + numberOfNewUsersPerGroup));
        return this;
    }

    public UsersAndGroupsControl resetLoginCount(String username) {
        this.get(this.createResource().path("user").path("resetLoginCount").queryParam("user", username));
        return this;
    }

    public long getNumberOfUsers() {
        return Long.parseLong((String)this.createResource().path("user").path("count").get(String.class));
    }

    public long getNumberOfGroups() {
        return Long.parseLong((String)this.createResource().path("group").path("count").get(String.class));
    }

    public LoginInfoBean getLoginInfo(String username) {
        return (LoginInfoBean)this.createResource().path("user").path("loginInfo").queryParam("userName", username).get(LoginInfoBean.class);
    }

    public List<UserDTO> getAllUsers() {
        return Arrays.asList((Object[])this.createResource().path("user").path("all").get(UserDTO[].class));
    }

    public UserDTO getUserByName(String username) {
        return (UserDTO)this.createResource().path("user").path("byName").queryParam("userName", username).get(UserDTO.class);
    }

    public void updateUser(UserDTO user) {
        this.createResource().path("user").path("byName").entity((Object)user, MediaType.APPLICATION_JSON_TYPE).post();
    }

    public List<DirectoryDTO> getAllDirectories() {
        return Arrays.asList((Object[])this.createResource().path("directory").get(DirectoryDTO[].class));
    }

    public DirectoryDTO getDirectory(long id) {
        return (DirectoryDTO)this.createResource().path("directory").path(String.valueOf(id)).get(DirectoryDTO.class);
    }

    @Override
    protected WebResource createResource() {
        return super.createResource().path("usersAndGroups");
    }
}

