/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client;

import com.atlassian.jira.testkit.beans.WorkflowSchemeData;
import com.atlassian.jira.testkit.client.BackdoorControl;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.util.Function;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import java.util.List;

public class WorkflowSchemesControl
extends BackdoorControl<WorkflowSchemesControl> {
    public WorkflowSchemesControl(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public WorkflowSchemeData getWorkflowSchemeByProjectKey(String projectKey) {
        WebResource workflowSchemeResource = this.createWorkflowSchemeResource();
        return (WorkflowSchemeData)workflowSchemeResource.queryParam("projectKey", projectKey).get(WorkflowSchemeData.class);
    }

    public WorkflowSchemeData getWorkflowSchemeByProjectName(String projectName) {
        WebResource workflowSchemeResource = this.createWorkflowSchemeResource();
        return (WorkflowSchemeData)workflowSchemeResource.queryParam("projectName", projectName).get(WorkflowSchemeData.class);
    }

    public WorkflowSchemeData getWorkflowSchemeByName(String schemeName) {
        WebResource workflowSchemeResource = this.createWorkflowSchemeResource();
        return (WorkflowSchemeData)workflowSchemeResource.queryParam("schemeName", schemeName).get(WorkflowSchemeData.class);
    }

    public WorkflowSchemeData getWorkflowSchemeByNameNullIfNotFound(final String schemeName) {
        return this.nullIfNotFound(new Function<Void, WorkflowSchemeData>(){

            public WorkflowSchemeData get(Void input) {
                return WorkflowSchemesControl.this.getWorkflowSchemeByName(schemeName);
            }
        });
    }

    public WorkflowSchemeData getWorkflowSchemeDraftByProjectNameNullIfNotFound(final String projectName) {
        return this.nullIfNotFound(new Function<Void, WorkflowSchemeData>(){

            public WorkflowSchemeData get(Void input) {
                return WorkflowSchemesControl.this.getWorkflowSchemeDraftByProjectName(projectName);
            }
        });
    }

    public WorkflowSchemeData getWorkflowSchemeDraftByProjectName(String projectName) {
        WebResource workflowSchemeResource = this.createWorkflowSchemeResource();
        return (WorkflowSchemeData)workflowSchemeResource.queryParam("projectName", projectName).queryParam("draft", "true").get(WorkflowSchemeData.class);
    }

    public WorkflowSchemeData getWorkflowSchemeDraftByProjectKey(String projectKey) {
        WebResource workflowSchemeResource = this.createWorkflowSchemeResource();
        return (WorkflowSchemeData)workflowSchemeResource.queryParam("projectKey", projectKey).queryParam("draft", "true").get(WorkflowSchemeData.class);
    }

    public List<WorkflowSchemeData> getWorkflowSchemes() {
        return (List)this.createWorkflowSchemeResource().get(WorkflowSchemeData.LIST);
    }

    public WorkflowSchemeData getWorkflowScheme(long id) {
        return (WorkflowSchemeData)this.createWorkflowSchemeResource(id).get(WorkflowSchemeData.class);
    }

    public WorkflowSchemeData getWorkflowSchemeForParent(long id) {
        return (WorkflowSchemeData)this.createDraftWorkflowSchemeResource(id).get(WorkflowSchemeData.class);
    }

    public WorkflowSchemeData getWorkflowSchemeForParentNullIfNotFound(final long id) {
        return this.nullIfNotFound(new Function<Void, WorkflowSchemeData>(){

            public WorkflowSchemeData get(Void aVoid) {
                return WorkflowSchemesControl.this.getWorkflowSchemeForParent(id);
            }
        });
    }

    public WorkflowSchemeData createDraft(WorkflowSchemeData scheme) {
        WebResource workflowSchemeResource = this.createWorkflowSchemeResource(scheme.getId());
        return (WorkflowSchemeData)workflowSchemeResource.path("draft").put(WorkflowSchemeData.class, (Object)scheme.getId());
    }

    public WorkflowSchemeData createScheme(WorkflowSchemeData scheme) {
        WebResource workflowSchemeResource = this.createWorkflowSchemeResource();
        return (WorkflowSchemeData)workflowSchemeResource.put(WorkflowSchemeData.class, (Object)scheme);
    }

    public WorkflowSchemeData updateScheme(WorkflowSchemeData scheme) {
        WebResource workflowSchemeResource = this.createWorkflowSchemeResource(scheme.getId());
        return (WorkflowSchemeData)workflowSchemeResource.put(WorkflowSchemeData.class, (Object)scheme);
    }

    public void deleteScheme(long id) {
        WebResource workflowSchemeResource = this.createWorkflowSchemeResource(id);
        workflowSchemeResource.delete();
    }

    public WorkflowSchemeData createDraftScheme(long parentId) {
        WebResource workflowSchemeResource = this.createDraftWorkflowSchemeResource(parentId);
        return (WorkflowSchemeData)workflowSchemeResource.put(WorkflowSchemeData.class, (Object)parentId);
    }

    public WorkflowSchemeData updateDraftScheme(long parentId, WorkflowSchemeData data) {
        WebResource workflowSchemeResource = this.createDraftWorkflowSchemeResource(parentId);
        return (WorkflowSchemeData)workflowSchemeResource.post(WorkflowSchemeData.class, (Object)data);
    }

    public void discardDraftScheme(long parentId) {
        WebResource workflowSchemeResource = this.createDraftWorkflowSchemeResource(parentId);
        workflowSchemeResource.delete();
    }

    public Long copyScheme(String schemeName, String newSchemeName) {
        return Long.parseLong((String)this.createWorkflowSchemeResource().path("copy").queryParam("schemeName", schemeName).queryParam("newSchemeName", newSchemeName).get(String.class));
    }

    public void assignScheme(long schemeId, String issueType, String workflowName) {
        WorkflowSchemeData scheme = this.getWorkflowScheme(schemeId).setMapping(issueType, workflowName);
        this.updateScheme(scheme);
    }

    private WebResource createWorkflowSchemeResource(long id) {
        return this.createWorkflowSchemeResource().path(String.valueOf(id));
    }

    private WebResource createDraftWorkflowSchemeResource(long id) {
        return this.createWorkflowSchemeResource(id).path("draft");
    }

    private WebResource createWorkflowSchemeResource() {
        return this.createResource().path("workflowscheme");
    }

    private WorkflowSchemeData nullIfNotFound(Function<Void, WorkflowSchemeData> function) {
        try {
            return (WorkflowSchemeData)function.get(null);
        }
        catch (UniformInterfaceException e) {
            if (ClientResponse.Status.NOT_FOUND.getStatusCode() == e.getResponse().getStatus()) {
                return null;
            }
            throw e;
        }
    }
}

