/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.log;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class MavenEnvironment {
    public static String getMavenAwareOutputDir() {
        File outputDir;
        File targetDir = new File("target");
        if (targetDir.exists() && targetDir.isDirectory() && targetDir.canWrite()) {
            outputDir = new File(targetDir, "test-reports");
        } else {
            try {
                File tmpFile = File.createTempFile("jirafunctests_", "dir");
                if (!tmpFile.delete()) {
                    throw new RuntimeException(String.format("Could not delete temp file '%s'", tmpFile.getAbsolutePath()));
                }
                outputDir = tmpFile;
            }
            catch (IOException e) {
                String tmpDirName = System.getProperty("java.io.tmpdir");
                String yymmdd = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
                outputDir = new File(tmpDirName + File.separator + "jirafunctests_" + yymmdd);
            }
        }
        if (!outputDir.exists() && !outputDir.mkdir()) {
            throw new RuntimeException(String.format("Could not create output directory '%s'", outputDir.getAbsolutePath()));
        }
        return outputDir.getAbsolutePath();
    }
}

