/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.restclient;

import com.atlassian.fugue.Option;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.IssueType;
import com.atlassian.jira.testkit.client.restclient.IssueTypeCreateBean;
import com.atlassian.jira.testkit.client.restclient.IssueTypeUpdateBean;
import com.atlassian.jira.testkit.client.restclient.Response;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import java.util.List;
import javax.ws.rs.core.MediaType;

public class IssueTypeClient
extends RestApiClient<IssueTypeClient> {
    public IssueTypeClient(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public List<IssueType> get() throws UniformInterfaceException {
        return (List)this.issueTypes().get((GenericType)new GenericType<List<IssueType>>(){});
    }

    public IssueType get(String issueTypeID) throws UniformInterfaceException {
        return (IssueType)this.issueTypeWithID(issueTypeID).get(IssueType.class);
    }

    public List<IssueType> getAlternatives(String issueTypeId) {
        return (List)this.issueTypeWithID(issueTypeId).path("alternatives").get((GenericType)new GenericType<List<IssueType>>(){});
    }

    public IssueType post(IssueTypeCreateBean issueTypeCreateBean) {
        return (IssueType)this.issueTypes().post(IssueType.class, (Object)issueTypeCreateBean);
    }

    public IssueType update(String issueTypeId, IssueTypeUpdateBean issueTypeUpdateBean) {
        return (IssueType)this.issueTypeWithID(issueTypeId).type(MediaType.APPLICATION_JSON_TYPE).put(IssueType.class, (Object)issueTypeUpdateBean);
    }

    public void delete(String issueTypeId, Option<String> alternativeIssueTypeId) {
        final WebResource webResource = this.issueTypeWithID(issueTypeId);
        alternativeIssueTypeId.fold((Supplier)new Supplier<Void>(){

            public Void get() {
                webResource.delete();
                return null;
            }
        }, (Function)new Function<String, Void>(){

            public Void apply(String alternativeId) {
                webResource.queryParam("alternativeIssueTypeId", alternativeId).delete();
                return null;
            }
        });
    }

    public Response getResponse(final String issueTypeID) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)IssueTypeClient.this.issueTypeWithID(issueTypeID).get(ClientResponse.class);
            }
        });
    }

    private WebResource.Builder issueTypes() {
        return this.createResource().path("issuetype").type(MediaType.APPLICATION_JSON_TYPE);
    }

    private WebResource issueTypeWithID(String issueTypeID) {
        return this.createResource().path("issuetype").path(issueTypeID);
    }
}

