/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.restclient;

import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.ProjectRole;
import com.atlassian.jira.testkit.client.restclient.ProjectRoleActorsBean;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.core.MediaType;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

public class RoleClient
extends RestApiClient<RoleClient> {
    public RoleClient(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public ProjectRole get(String roleKey) {
        return (ProjectRole)this.roles().path(roleKey).get(ProjectRole.class);
    }

    public List<ProjectRole> get() {
        return (List)this.roles().get((GenericType)new GenericType<List<ProjectRole>>(){});
    }

    public ProjectRole create(String name, String description) {
        return (ProjectRole)this.roles().type(MediaType.APPLICATION_JSON_TYPE).post(ProjectRole.class, (Object)new CreateProjectRoleBean(name, description));
    }

    public ProjectRole updatePartial(Long id, String name, String description) {
        return (ProjectRole)this.roles().path(String.valueOf(id)).type(MediaType.APPLICATION_JSON_TYPE).post(ProjectRole.class, (Object)new CreateProjectRoleBean(name, description));
    }

    public ProjectRole updateFull(Long id, String name, String description) {
        return (ProjectRole)this.roles().path(String.valueOf(id)).type(MediaType.APPLICATION_JSON_TYPE).put(ProjectRole.class, (Object)new CreateProjectRoleBean(name, description));
    }

    public void deleteProjectRole(Long id) {
        this.roles().path(String.valueOf(id)).delete();
    }

    public void deleteProjectRole(Long id, Long replacementId) {
        this.roles().path(String.valueOf(id)).queryParam("swap", String.valueOf(replacementId)).delete();
    }

    public ProjectRoleActorsBean getDefaultActorsForRole(Long id) {
        return (ProjectRoleActorsBean)this.roles().path(String.valueOf(id)).path("actors").get(ProjectRoleActorsBean.class);
    }

    public ProjectRoleActorsBean addDefaultActorsToRole(Long id, String[] usernames, String[] groupnames) {
        return (ProjectRoleActorsBean)this.roles().path(String.valueOf(id)).path("actors").type(MediaType.APPLICATION_JSON_TYPE).post(ProjectRoleActorsBean.class, (Object)new ActorInputBean(usernames == null ? null : Arrays.asList(usernames), groupnames == null ? null : Arrays.asList(groupnames)));
    }

    public ProjectRoleActorsBean deleteDefaultActorsToRole(Long id, String username, String groupname) {
        WebResource actors = this.roles().path(String.valueOf(id)).path("actors");
        if (username != null) {
            actors = actors.queryParam("user", username);
        }
        if (groupname != null) {
            actors = actors.queryParam("group", groupname);
        }
        return (ProjectRoleActorsBean)actors.delete(ProjectRoleActorsBean.class);
    }

    protected WebResource roles() {
        return this.createResource().path("role");
    }

    private static class ActorInputBean {
        @JsonProperty
        private Collection<String> user;
        @JsonProperty
        private Collection<String> group;

        @JsonCreator
        public ActorInputBean(@JsonProperty(value="user") Collection<String> usernames, @JsonProperty(value="group") Collection<String> groupnames) {
            this.user = usernames;
            this.group = groupnames;
        }
    }

    private static class CreateProjectRoleBean {
        @JsonProperty
        private String name;
        @JsonProperty
        private String description;

        public CreateProjectRoleBean(String name, String description) {
            this.name = name;
            this.description = description;
        }
    }
}

