/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.rules;

import com.atlassian.jira.testkit.client.Backdoor;
import com.atlassian.jira.testkit.client.model.FeatureFlag;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import javax.annotation.ParametersAreNonnullByDefault;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

@ParametersAreNonnullByDefault
public class FeatureFlagRule
implements TestRule {
    private final Backdoor backdoor;
    private final Collection<FeatureFlag> featureFlagsToEnable;
    private final Collection<FeatureFlag> featureFlagsToDisable;

    public FeatureFlagRule(Backdoor backdoor, Collection<FeatureFlag> featureFlagsToEnable) {
        this(backdoor, featureFlagsToEnable, (Collection<FeatureFlag>)ImmutableList.of());
    }

    public FeatureFlagRule(Backdoor backdoor, Collection<FeatureFlag> featureFlagsToEnable, Collection<FeatureFlag> featureFlagsToDisable) {
        this.backdoor = (Backdoor)Assertions.notNull((Object)backdoor);
        this.featureFlagsToEnable = ImmutableList.copyOf(featureFlagsToEnable);
        this.featureFlagsToDisable = ImmutableList.copyOf(featureFlagsToDisable);
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                FeatureFlagRule.this.featureFlagsToEnable.forEach(FeatureFlagRule.this.backdoor.darkFeatures()::enableForSite);
                FeatureFlagRule.this.featureFlagsToDisable.forEach(FeatureFlagRule.this.backdoor.darkFeatures()::disableForSite);
                try {
                    base.evaluate();
                }
                finally {
                    FeatureFlagRule.this.featureFlagsToEnable.forEach(FeatureFlagRule.this.backdoor.darkFeatures()::resetForSite);
                    FeatureFlagRule.this.featureFlagsToDisable.forEach(FeatureFlagRule.this.backdoor.darkFeatures()::resetForSite);
                }
            }
        };
    }
}

