/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.util;

import com.atlassian.fugue.Option;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.json.JSONException;
import org.json.JSONObject;

public final class JsonMatchers {
    public static JsonHasFieldMatcher hasField(String field) {
        return new JsonHasFieldMatcher(field);
    }

    public static final class JsonHasFieldMatcher
    extends TypeSafeMatcher<JSONObject> {
        private final String field;

        private JsonHasFieldMatcher(String field) {
            this.field = field;
        }

        public Matcher<JSONObject> equalTo(final Object value) {
            return Matchers.allOf((Iterable)Lists.newArrayList((Object[])new Matcher[]{this, new TypeSafeMatcher<JSONObject>(){

                protected boolean matchesSafely(JSONObject item) {
                    return value.equals(this.getValueOfField(item).getOrNull());
                }

                public void describeTo(Description description) {
                    description.appendText("that it is equal to '" + value + "'");
                }
            }}));
        }

        protected boolean matchesSafely(JSONObject item) {
            return this.getValueOfField(item).isDefined();
        }

        private Option<Object> getValueOfField(JSONObject item) {
            JSONObject object = item;
            LinkedList chain = Lists.newLinkedList((Iterable)Splitter.on((char)'.').split((CharSequence)this.field));
            try {
                while (chain.size() > 1) {
                    object = object.getJSONObject((String)chain.pop());
                }
                return Option.some((Object)object.get((String)chain.pop()));
            }
            catch (JSONException e) {
                return Option.none();
            }
        }

        public void describeTo(Description description) {
            description.appendText("JSON expected to have field '" + this.field + "'");
        }
    }
}

