/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.beans;

import com.atlassian.jira.testkit.beans.Field;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.codehaus.jackson.annotate.JsonProperty;

public class Screen
implements Iterable<Tab> {
    @JsonProperty
    private long id;
    @JsonProperty
    private String name;
    @JsonProperty
    private List<Tab> tabs;

    public Screen() {
    }

    public Screen(long id, String name, Iterable<? extends Tab> tabs) {
        this.id = id;
        this.name = name;
        this.tabs = ImmutableList.copyOf(tabs);
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public List<Tab> getTabs() {
        return this.tabs;
    }

    @Override
    public Iterator<Tab> iterator() {
        return this.getTabs().iterator();
    }

    public List<String> getFields() {
        ArrayList fields = Lists.newArrayList();
        for (Tab tab : this) {
            Iterables.addAll((Collection)fields, (Iterable)Iterables.transform((Iterable)tab, Field.GET_NAME));
        }
        return fields;
    }

    public static class Tab
    implements Iterable<Field> {
        @JsonProperty
        private String name;
        @JsonProperty
        private Long id;
        @JsonProperty
        private List<Field> fields;

        public Tab() {
        }

        public Tab(String name, Iterable<? extends Field> fields) {
            this(null, name, fields);
        }

        public Tab(Long id, String name, Iterable<? extends Field> fields) {
            this.fields = ImmutableList.copyOf(fields);
            this.name = name;
            this.id = id;
        }

        public List<Field> getFields() {
            return this.fields;
        }

        public String getName() {
            return this.name;
        }

        public Long getId() {
            return this.id;
        }

        @Override
        public Iterator<Field> iterator() {
            return this.fields.iterator();
        }
    }
}

