/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.restclient;

import java.util.List;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class UserBean {
    public String self;
    public String name;
    public String displayName;
    public String key;
    public String password;
    public String emailAddress;
    public String notification;
    private List<String> applicationKeys;

    public UserBean() {
    }

    public UserBean(String name, String displayName, String key, String password, String emailAddress, String notification, List<String> applicationKeys) {
        this.name = name;
        this.displayName = displayName;
        this.key = key;
        this.password = password;
        this.emailAddress = emailAddress;
        this.notification = notification;
        this.applicationKeys = applicationKeys;
    }

    public UserBean(String name, String displayName, String key, String password, String emailAddress, String notification) {
        this.name = name;
        this.displayName = displayName;
        this.key = key;
        this.password = password;
        this.emailAddress = emailAddress;
        this.notification = notification;
    }

    @JsonIgnore
    public Builder but() {
        return UserBean.builder().setDisplayName(this.displayName).setEmailAddress(this.emailAddress).setKey(this.key).setName(this.name).setNotification(this.notification).setPassword(this.password).setApplicationKeys(this.applicationKeys);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getKey() {
        return this.key;
    }

    public String getPassword() {
        return this.password;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public String getNotification() {
        return this.notification;
    }

    public String getSelf() {
        return this.self;
    }

    public List<String> getApplicationKeys() {
        return this.applicationKeys;
    }

    public static class Builder {
        private String name;
        private String displayName;
        private String key;
        private String password;
        private String emailAddress;
        private String notification;
        private List<String> applicationKeys;

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setDisplayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder setKey(String key) {
            this.key = key;
            return this;
        }

        public Builder setPassword(String password) {
            this.password = password;
            return this;
        }

        public Builder setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public Builder setNotification(String notification) {
            this.notification = notification;
            return this;
        }

        public Builder setApplicationKeys(List<String> roles) {
            this.applicationKeys = roles;
            return this;
        }

        public UserBean build() {
            return new UserBean(this.name, this.displayName, this.key, this.password, this.emailAddress, this.notification, this.applicationKeys);
        }
    }
}

