/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.jersey;

import com.sun.jersey.api.model.AbstractMethod;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerRequestFilter;
import com.sun.jersey.spi.container.ContainerResponse;
import com.sun.jersey.spi.container.ContainerResponseFilter;
import com.sun.jersey.spi.container.ResourceFilter;
import com.sun.jersey.spi.container.ResourceFilterFactory;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class TestKitResourceFilterFactory
implements ResourceFilterFactory {
    private static final Logger log = LoggerFactory.getLogger(TestKitResourceFilterFactory.class);

    public List<ResourceFilter> create(AbstractMethod am) {
        return Collections.singletonList(new ResourceFilter(){

            public ContainerRequestFilter getRequestFilter() {
                return null;
            }

            public ContainerResponseFilter getResponseFilter() {
                return new CacheControlResponseFilter();
            }
        });
    }

    private static class CacheControlResponseFilter
    implements ContainerResponseFilter {
        private CacheControlResponseFilter() {
        }

        public ContainerResponse filter(ContainerRequest request, ContainerResponse response) {
            MultivaluedMap headers = response.getHttpHeaders();
            if (!headers.containsKey((Object)"Cache-Control") && !headers.containsKey((Object)"Expires")) {
                log.trace("Response does not have caching headers, adding 'Cache-Control: no-cache, no-store'");
                headers.putSingle((Object)"Cache-Control", (Object)"no-cache, no-store");
            }
            return response;
        }
    }
}

