/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.plugin;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.context.GlobalIssueContext;
import com.atlassian.jira.issue.context.JiraContextNode;
import com.atlassian.jira.issue.customfields.CustomFieldSearcher;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.issue.customfields.config.item.SettableOptionsConfigItem;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.customfields.option.Options;
import com.atlassian.jira.issue.fields.ConfigurableField;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigItem;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.testkit.beans.CustomFieldConfig;
import com.atlassian.jira.testkit.beans.CustomFieldDefaultValue;
import com.atlassian.jira.testkit.beans.CustomFieldOption;
import com.atlassian.jira.testkit.beans.CustomFieldRequest;
import com.atlassian.jira.testkit.beans.CustomFieldResponse;
import com.atlassian.jira.testkit.plugin.util.CacheControl;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.ofbiz.core.entity.GenericEntityException;

@Path(value="customFields")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class CustomFieldsBackdoor {
    private final CustomFieldManager customFieldManager;
    private final ConstantsManager constantsManager;
    private final FieldConfigSchemeManager fieldConfigSchemeManager;
    private final ProjectManager projectManager;

    public CustomFieldsBackdoor(CustomFieldManager customFieldManager, ConstantsManager constantsManager, FieldConfigSchemeManager fieldConfigSchemeManager, ProjectManager projectManager) {
        this.customFieldManager = customFieldManager;
        this.constantsManager = constantsManager;
        this.fieldConfigSchemeManager = fieldConfigSchemeManager;
        this.projectManager = projectManager;
    }

    @POST
    @AnonymousAllowed
    @Path(value="create")
    public Response createCustomField(CustomFieldRequest field) {
        CustomFieldType type = this.customFieldManager.getCustomFieldType(field.type);
        if (type == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Custom field type with key '" + field.type + "' does not exist")).build();
        }
        CustomFieldSearcher searcher = null;
        if (field.searcherKey != null) {
            List searchers = this.customFieldManager.getCustomFieldSearchers(type);
            try {
                searcher = searchers.stream().filter(customFieldSearcher -> field.searcherKey.equals(customFieldSearcher.getDescriptor().getCompleteKey())).findFirst().orElseThrow(NoSuchElementException::new);
            }
            catch (NoSuchElementException e) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Searcher with key " + field.searcherKey + " not found for type '" + field.type + "'")).build();
            }
        }
        List<JiraContextNode> contexts = Collections.singletonList(GlobalIssueContext.getInstance());
        List<Object> allTypes = Collections.singletonList(null);
        try {
            CustomField result = this.customFieldManager.createCustomField(field.name, field.description, type, searcher, contexts, allTypes);
            return Response.ok((Object)this.asResponse(result, false)).cacheControl(CacheControl.never()).build();
        }
        catch (GenericEntityException e) {
            throw new IllegalStateException("Something went really wrong", e);
        }
    }

    @PUT
    @Path(value="{id}")
    public Response updateCustomField(@PathParam(value="id") String customFieldId, CustomFieldRequest field) {
        if (customFieldId == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Please supply custom field id").build();
        }
        CustomField customField = this.customFieldManager.getCustomFieldObject(customFieldId);
        if (customField == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Custom field with id " + customFieldId + " does not exist")).build();
        }
        if (field.type != null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Type cannot be changed").build();
        }
        CustomFieldSearcher searcher = null;
        if (field.searcherKey != null) {
            List searchers = this.customFieldManager.getCustomFieldSearchers(customField.getCustomFieldType());
            try {
                searcher = searchers.stream().filter(customFieldSearcher -> field.searcherKey.equals(customFieldSearcher.getDescriptor().getCompleteKey())).findFirst().orElseThrow(NoSuchElementException::new);
            }
            catch (NoSuchElementException e) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Searcher with key " + field.searcherKey + " not found for type '" + field.type + "'")).build();
            }
        }
        this.customFieldManager.updateCustomField(customField.getIdAsLong(), field.name, field.description, searcher);
        return Response.ok().build();
    }

    @GET
    @Path(value="{id}")
    public Response updateCustomField(@PathParam(value="id") String customFieldId, @QueryParam(value="config") boolean config) {
        if (customFieldId == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Please supply custom field id").build();
        }
        CustomField customField = this.customFieldManager.getCustomFieldObject(customFieldId);
        if (customField == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Custom field with id " + customFieldId + " does not exist")).build();
        }
        return Response.ok((Object)this.asResponse(customField, config)).build();
    }

    @POST
    @AnonymousAllowed
    @Path(value="addOption/{id}")
    public Response addOption(@PathParam(value="id") String customFieldId, String optionValue) {
        if (customFieldId == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Please supply custom field id").build();
        }
        CustomField customField = this.customFieldManager.getCustomFieldObject(customFieldId);
        if (customField == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Custom field with id " + customFieldId + " does not exist")).build();
        }
        Options options = customField.getOptions(null, GlobalIssueContext.getInstance());
        if (options != null) {
            options.addOption(options.getOptionById(null), optionValue);
        }
        return Response.ok().build();
    }

    @DELETE
    @AnonymousAllowed
    @Path(value="deleteOption/{id}")
    public Response deleteOption(@PathParam(value="id") String customFieldId, String optionValue) {
        Option toDelete;
        if (customFieldId == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Please supply custom field id").build();
        }
        CustomField customField = this.customFieldManager.getCustomFieldObject(customFieldId);
        if (customField == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Custom field with id " + customFieldId + " does not exist")).build();
        }
        Options options = customField.getOptions(null, GlobalIssueContext.getInstance());
        if (options != null && (toDelete = options.getOptionForValue(optionValue, null)) != null) {
            options.removeOption(toDelete);
        }
        return Response.ok().build();
    }

    @GET
    @AnonymousAllowed
    @Path(value="get")
    public Response getCustomFields(@QueryParam(value="config") boolean config) {
        List result = this.customFieldManager.getCustomFieldObjects().stream().map(input -> this.asResponse((CustomField)input, config)).collect(Collectors.toList());
        return Response.ok(result).cacheControl(CacheControl.never()).build();
    }

    @DELETE
    @AnonymousAllowed
    @Path(value="delete/{id}")
    public Response deleteCustomField(@PathParam(value="id") String customFieldId) {
        if (customFieldId == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Please supply custom field id").build();
        }
        CustomField customField = this.customFieldManager.getCustomFieldObject(customFieldId);
        if (customField == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Custom field with id " + customFieldId + " does not exist")).build();
        }
        try {
            this.customFieldManager.removeCustomField(customField);
            return Response.ok().build();
        }
        catch (RemoveException e) {
            throw new IllegalStateException("Something went wrong: ", e);
        }
    }

    @Path(value="addCustomFieldContext")
    @POST
    public Response addContext(@QueryParam(value="customFieldId") Long customFieldId, @QueryParam(value="projectIds") List<Long> projectIds, @QueryParam(value="issueTypeIds") List<String> issueTypeIds) {
        String[] stringArray;
        Long[] projectIdArray = projectIds.toArray(new Long[0]);
        if (issueTypeIds.isEmpty()) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = null;
        } else {
            stringArray = issueTypeIds.toArray(new String[0]);
        }
        String[] issueTypeIdArray = stringArray;
        FieldConfigScheme configScheme = new FieldConfigScheme.Builder(null).setName("New Scheme").setDescription("Dummy description").toFieldConfigScheme();
        List contexts = CustomFieldUtils.buildJiraIssueContexts((boolean)false, (Long[])projectIdArray, (ProjectManager)this.projectManager);
        List issueTypes = CustomFieldUtils.buildIssueTypes((ConstantsManager)this.constantsManager, (String[])issueTypeIdArray);
        CustomField customField = this.customFieldManager.getCustomFieldObject(customFieldId);
        FieldConfigScheme result = this.fieldConfigSchemeManager.createFieldConfigScheme(configScheme, contexts, issueTypes, (ConfigurableField)customField);
        return Response.ok((Object)result.getId().toString()).build();
    }

    @Path(value="deleteCustomFieldContext")
    @DELETE
    public Response deleteContext(@QueryParam(value="contextId") Long contextId) {
        this.fieldConfigSchemeManager.removeFieldConfigScheme(contextId);
        return Response.noContent().build();
    }

    @PUT
    @Path(value="setDefaultValueForContext")
    public Response updateCustomFieldDefaultValue(@QueryParam(value="contextId") Long fieldConfigSchemeId, CustomFieldDefaultValue defaultValue) {
        if (fieldConfigSchemeId == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Please supply custom field context id (field config scheme id)").build();
        }
        FieldConfigScheme fieldConfigScheme = this.fieldConfigSchemeManager.getFieldConfigScheme(fieldConfigSchemeId);
        if (fieldConfigScheme == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Field config scheme not found").build();
        }
        ConfigurableField field = fieldConfigScheme.getField();
        if (!(field instanceof CustomField)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"ConfigurableField associated with field config scheme is not CustomField").build();
        }
        CustomField customField = (CustomField)field;
        customField.getCustomFieldType().setDefaultValue(fieldConfigScheme.getOneAndOnlyConfig(), defaultValue.value);
        return Response.ok().build();
    }

    private CustomFieldResponse asResponse(CustomField input, boolean config) {
        CustomFieldSearcher customFieldSearcher = input.getCustomFieldSearcher();
        String searcherKey = customFieldSearcher == null ? null : customFieldSearcher.getDescriptor().getCompleteKey();
        CustomFieldResponse response = new CustomFieldResponse(input.getName(), input.getId(), input.getCustomFieldType().getKey(), input.getDescription(), searcherKey);
        if (config) {
            response.setConfig(this.getConfig(input));
        }
        return response;
    }

    private List<CustomFieldConfig> getConfig(CustomField input) {
        ArrayList config = Lists.newArrayList();
        for (FieldConfigScheme fieldConfigScheme : input.getConfigurationSchemes()) {
            FieldConfig onlyConfig = fieldConfigScheme.getOneAndOnlyConfig();
            if (onlyConfig == null) continue;
            CustomFieldConfig bean = new CustomFieldConfig();
            bean.setId(onlyConfig.getId());
            bean.setProjects(this.getProjectNames(fieldConfigScheme.getAssociatedProjectObjects()));
            bean.setIssueTypes(this.getIssueTypeNames(fieldConfigScheme.getConfigs().keySet()));
            for (FieldConfigItem item : onlyConfig.getConfigItems()) {
                if (!(item.getType() instanceof SettableOptionsConfigItem)) continue;
                bean.setOptions(this.convertOptions((List<Option>)((Options)item.getConfigurationObject(null))));
            }
            config.add(bean);
        }
        return config;
    }

    private List<CustomFieldOption> convertOptions(List<Option> options) {
        return options.stream().map(this::convertOption).collect(Collectors.toList());
    }

    private CustomFieldOption convertOption(Option option) {
        CustomFieldOption customFieldOption = new CustomFieldOption();
        customFieldOption.setId(option.getOptionId());
        customFieldOption.setName(option.getValue());
        customFieldOption.setChildren(this.convertOptions(option.getChildOptions()));
        return customFieldOption;
    }

    private Set<String> getProjectNames(List<Project> projects) {
        return projects.stream().filter(Objects::nonNull).map(Project::getName).collect(Collectors.toSet());
    }

    private Set<String> getIssueTypeNames(Set<String> ids) {
        return ids.stream().filter(Objects::nonNull).map(id -> this.constantsManager.getIssueTypeObject(id).getName()).collect(Collectors.toSet());
    }
}

