/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.plugin;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.FeatureFlag;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.google.common.annotations.VisibleForTesting;
import io.atlassian.fugue.Option;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="darkFeatures")
public class DarkFeaturesBackdoor {
    @GET
    @AnonymousAllowed
    @Path(value="user/enable")
    public Response enableForUser(@QueryParam(value="username") String username, @QueryParam(value="feature") String feature) {
        ApplicationUser user = ComponentAccessor.getUserUtil().getUserByName(username);
        this.getFeatureManager().enableUserDarkFeature(user, feature);
        return Response.ok(null).build();
    }

    @GET
    @AnonymousAllowed
    @Path(value="user/disable")
    public Response disableForUser(@QueryParam(value="username") String username, @QueryParam(value="feature") String feature) {
        ApplicationUser user = ComponentAccessor.getUserUtil().getUserByName(username);
        this.getFeatureManager().disableUserDarkFeature(user, feature);
        return Response.ok(null).build();
    }

    @GET
    @AnonymousAllowed
    @Path(value="site/enable")
    public Response enableForSite(@QueryParam(value="feature") String feature) {
        this.getFeatureManager().enableSiteDarkFeature(feature);
        return Response.ok(null).build();
    }

    @GET
    @AnonymousAllowed
    @Path(value="site/disable")
    public Response disableForSite(@QueryParam(value="feature") String feature) {
        this.getFeatureManager().disableSiteDarkFeature(feature);
        return Response.ok(null).build();
    }

    @GET
    @AnonymousAllowed
    @Path(value="global/enabled")
    public Response isGloballyEnabled(@QueryParam(value="feature") String feature) {
        Option featureFlag;
        FeatureManager featureManager = this.getFeatureManager();
        boolean isEnabled = this.isFeatureEnabled(featureManager, feature, (Option<FeatureFlag>)(featureFlag = featureManager.getFeatureFlag(feature))) ? this.isFeatureFlagOnByDefault((Option<FeatureFlag>)featureFlag) || this.isEnabledFeatureCreatedAsGlobalDarkFeature(featureManager, feature, (Option<FeatureFlag>)featureFlag) : (this.isFeatureFlagOnByDefault((Option<FeatureFlag>)featureFlag) ? !this.isDisabledFeatureCreatedAsGlobalDarkFeature(featureManager, feature, (Option<FeatureFlag>)featureFlag) : false);
        return Response.ok((Object)Boolean.toString(isEnabled)).build();
    }

    private boolean isFeatureEnabled(FeatureManager featureManager, String feature, Option<FeatureFlag> featureFlagOption) {
        return (Boolean)featureFlagOption.map(arg_0 -> ((FeatureManager)featureManager).isEnabled(arg_0)).getOrElse(() -> featureManager.isEnabled(feature));
    }

    private boolean isFeatureFlagOnByDefault(Option<FeatureFlag> featureFlagOption) {
        return featureFlagOption.exists(FeatureFlag::isOnByDefault);
    }

    private boolean isEnabledFeatureCreatedAsGlobalDarkFeature(FeatureManager featureManager, String feature, Option<FeatureFlag> featureFlagOption) {
        String featureKeyEnabled = (String)featureFlagOption.map(FeatureFlag::enabledFeatureKey).getOrElse((Object)feature);
        return featureManager.getDarkFeatures().getGlobalEnabledFeatureKeys().contains(featureKeyEnabled);
    }

    private boolean isDisabledFeatureCreatedAsGlobalDarkFeature(FeatureManager featureManager, String feature, Option<FeatureFlag> featureFlagOption) {
        String featureKeyDisabled = (String)featureFlagOption.map(FeatureFlag::disabledFeatureKey).getOrElse((Object)feature);
        return featureManager.getDarkFeatures().getGlobalEnabledFeatureKeys().contains(featureKeyDisabled);
    }

    @VisibleForTesting
    protected FeatureManager getFeatureManager() {
        return (FeatureManager)ComponentAccessor.getComponent(FeatureManager.class);
    }
}

