/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.plugin;

import com.atlassian.jira.bc.dataimport.DataImportParams;
import com.atlassian.jira.bc.dataimport.DataImportService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.testkit.plugin.DataImportBean;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.google.common.collect.Iterables;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;

@Path(value="dataImport")
@AnonymousAllowed
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class DataImportBackdoor {
    private final UserUtil userUtil;
    private final BuildUtilsInfo buildInfo;
    private final ApplicationProperties applicationProperties;
    private final JiraHome jiraHome;
    private volatile DataImportService dataImportService;

    public DataImportBackdoor(UserUtil userUtil, BuildUtilsInfo buildInfo, JiraHome jiraHome, ApplicationProperties applicationProperties) {
        this.userUtil = userUtil;
        this.buildInfo = buildInfo;
        this.applicationProperties = applicationProperties;
        this.jiraHome = jiraHome;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    public Response importData(DataImportBean importBean) {
        String licenseString = importBean.licenseString;
        boolean useDefaultPaths = importBean.useDefaultPaths;
        boolean quickImport = importBean.quickImport;
        DataImportParams params = new DataImportParams.Builder(importBean.filePath).setLicenseString(licenseString).setUseDefaultPaths(useDefaultPaths).setQuickImport(quickImport).build();
        Thread thd = Thread.currentThread();
        ClassLoader originalClassLoader = thd.getContextClassLoader();
        ClassLoader webappClassLoader = ComponentAccessor.class.getClassLoader();
        try {
            thd.setContextClassLoader(webappClassLoader);
            ApplicationUser sysadmin = (ApplicationUser)Iterables.get((Iterable)this.userUtil.getJiraSystemAdministrators(), (int)0);
            DataImportService.ImportValidationResult result = this.getDataImportService().validateImport(sysadmin, params);
            DataImportService.ImportResult importResult = this.getDataImportService().doImport(sysadmin, result, TaskProgressSink.NULL_SINK);
            if (!importResult.isValid()) {
                throw new IllegalStateException("Restore failed!: " + importResult.getImportError() + ". More Info: " + importResult.getSpecificErrorMessage());
            }
            if (StringUtils.isNotBlank((String)importBean.baseUrl)) {
                this.applicationProperties.setString("jira.baseurl", importBean.baseUrl);
            }
            Response response = Response.ok(null).build();
            return response;
        }
        finally {
            thd.setContextClassLoader(originalClassLoader);
        }
    }

    @GET
    @Path(value="jiraHomePath")
    public Response getJiraHomePath() {
        String jiraHomePath = this.jiraHome.getHomePath();
        return Response.ok((Object)jiraHomePath).build();
    }

    @GET
    @Path(value="importConfig")
    public Response getImportConfig() {
        String jiraHomePath = this.jiraHome.getHomePath();
        int buildNumber = this.buildInfo.getApplicationBuildNumber();
        return Response.ok((Object)new ImportConfig(jiraHomePath, buildNumber)).build();
    }

    public DataImportService getDataImportService() {
        if (this.dataImportService == null) {
            this.dataImportService = (DataImportService)ComponentAccessor.getComponent(DataImportService.class);
        }
        return this.dataImportService;
    }

    public static final class ImportConfig {
        public String jiraHome;
        public int buildNumber;

        public ImportConfig(String jiraHome, int buildNumber) {
            this.jiraHome = jiraHome;
            this.buildNumber = buildNumber;
        }
    }
}

