/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.plugin;

import com.atlassian.annotations.security.XsrfProtectionExcluded;
import com.atlassian.jira.issue.security.IssueSecurityLevel;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.issue.security.IssueSecuritySchemeManager;
import com.atlassian.jira.permission.JiraPermissionHolderType;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.scheme.SchemeEntity;
import com.atlassian.jira.testkit.plugin.PermissionSchemesBackdoor;
import com.atlassian.jira.testkit.plugin.util.CacheControl;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="issueSecuritySchemes")
@Produces(value={"application/json"})
public class IssueSecuritySchemesBackdoor {
    private final Logger log = LoggerFactory.getLogger(PermissionSchemesBackdoor.class);
    private final IssueSecuritySchemeManager schemeManager;
    private final IssueSecurityLevelManager levelManager;

    public IssueSecuritySchemesBackdoor(IssueSecuritySchemeManager schemeManager, IssueSecurityLevelManager levelManager) {
        this.schemeManager = schemeManager;
        this.levelManager = levelManager;
    }

    private List<GenericValue> getSecurityLevels(List<GenericValue> securityLevels, long securityLevelId) {
        return securityLevels.stream().filter(genericValue -> {
            Long id = (Long)genericValue.get("id");
            Long securityId = (Long)genericValue.get("security");
            return id != null && securityId != null && securityId == securityLevelId;
        }).collect(Collectors.toList());
    }

    @GET
    @AnonymousAllowed
    @Path(value="create")
    public Response create(@QueryParam(value="schemeName") String newSchemeName, @QueryParam(value="schemeDescription") String description) {
        Scheme copyScheme = this.schemeManager.createSchemeObject(newSchemeName, description);
        return Response.ok((Object)copyScheme.getId()).build();
    }

    @DELETE
    @Path(value="{schemeId}")
    public Response delete(@PathParam(value="schemeId") Long schemeId) {
        try {
            this.schemeManager.deleteScheme(schemeId);
        }
        catch (GenericEntityException e) {
            throw new RuntimeException(e);
        }
        return Response.ok().cacheControl(CacheControl.never()).build();
    }

    @POST
    @Path(value="{schemeId}")
    @XsrfProtectionExcluded
    public Response addSecurityLevel(@PathParam(value="schemeId") int id, @QueryParam(value="name") String name, @QueryParam(value="description") String description) {
        IssueSecurityLevel issueSecurityLevel = this.levelManager.createIssueSecurityLevel((long)id, name, description);
        return Response.ok().entity((Object)issueSecurityLevel.getId()).cacheControl(CacheControl.never()).build();
    }

    @POST
    @Path(value="{schemeId}/{securityLevelId}")
    @XsrfProtectionExcluded
    public Response addUserToSecurityLevel(@PathParam(value="schemeId") long schemeId, @PathParam(value="securityLevelId") long securityLevelId, @QueryParam(value="userKey") String userKey) throws GenericEntityException {
        SchemeEntity entity = new SchemeEntity(JiraPermissionHolderType.USER.getKey(), userKey, (Object)securityLevelId);
        GenericValue scheme = this.schemeManager.getScheme(Long.valueOf(schemeId));
        this.schemeManager.createSchemeEntity(scheme, entity);
        this.levelManager.clearUsersLevels();
        return Response.ok().cacheControl(CacheControl.never()).build();
    }

    @DELETE
    @Path(value="{schemeId}/{securityLevelId}/user/{userKey}")
    @XsrfProtectionExcluded
    public Response deleteUserFromSecurityLevel(@PathParam(value="schemeId") long schemeId, @PathParam(value="securityLevelId") long securityLevelId, @PathParam(value="userKey") String userKey) throws GenericEntityException {
        List allEntities = this.schemeManager.getEntities(JiraPermissionHolderType.USER.getKey(), userKey);
        List<GenericValue> filteredEntities = this.getSecurityLevels(allEntities, securityLevelId);
        if (filteredEntities.size() > 1) {
            return Response.serverError().cacheControl(CacheControl.never()).build();
        }
        if (filteredEntities.size() == 0) {
            this.log.info("Attempted to remove an entity which does not exist; ignoring");
            return Response.ok().build();
        }
        Long entityId = (Long)filteredEntities.get(0).get("id");
        this.schemeManager.deleteEntity(entityId);
        return Response.ok().cacheControl(CacheControl.never()).build();
    }

    @DELETE
    @Path(value="{schemeId}/{securityLevelId}/userCF/{userKey}")
    @XsrfProtectionExcluded
    public Response deleteUserCustomFieldFromSecurityLevel(@PathParam(value="schemeId") long schemeId, @PathParam(value="securityLevelId") long securityLevelId, @PathParam(value="userKey") String customField) throws GenericEntityException {
        List allEntities = this.schemeManager.getEntities(JiraPermissionHolderType.USER_CUSTOM_FIELD.getKey(), customField);
        List<GenericValue> entities = this.getSecurityLevels(allEntities, securityLevelId);
        if (entities.size() > 1) {
            return Response.serverError().cacheControl(CacheControl.never()).build();
        }
        if (entities.size() == 0) {
            this.log.info("Attempted to remove an entity which does not exist; ignoring");
            return Response.ok().build();
        }
        Long entityId = (Long)entities.get(0).get("id");
        this.schemeManager.deleteEntity(entityId);
        return Response.ok().cacheControl(CacheControl.never()).build();
    }

    @DELETE
    @Path(value="{schemeId}/{securityLevelId}")
    @XsrfProtectionExcluded
    public Response removeSecurityLevel(@PathParam(value="schemeId") int id, @PathParam(value="securityLevelId") int securityId) {
        List filteredLevels = this.levelManager.getIssueSecurityLevels((long)id).stream().filter(issueSecurityLevel -> issueSecurityLevel.getId() == (long)securityId).collect(Collectors.toList());
        if (filteredLevels.size() > 1) {
            return Response.serverError().cacheControl(CacheControl.never()).build();
        }
        if (filteredLevels.size() == 0) {
            this.log.info("Attempted to remove an entity which does not exist; ignoring");
            return Response.ok().build();
        }
        this.levelManager.deleteSecurityLevel(((IssueSecurityLevel)filteredLevels.get(0)).getId());
        return Response.ok().build();
    }
}

