/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.plugin;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.IssueTypeManager;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.testkit.plugin.util.CacheControl;
import com.atlassian.jira.testkit.plugin.util.Errors;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.annotate.JsonProperty;

@Path(value="issueType")
@AnonymousAllowed
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class IssueTypeBackdoorResource {
    private static final String SUBTASK = "jira_subtask";
    private static final String TASK = "";
    private final ConstantsManager constantsManager;
    private final IssueTypeManager issueTypeManager;
    private final ProjectManager projectManager;
    private final IssueTypeSchemeManager issueTypeSchemeManager;

    public IssueTypeBackdoorResource(ConstantsManager constantsManager, IssueTypeManager issueTypeManager, ProjectManager projectManager, IssueTypeSchemeManager issueTypeSchemeManager) {
        this.constantsManager = constantsManager;
        this.issueTypeManager = issueTypeManager;
        this.projectManager = projectManager;
        this.issueTypeSchemeManager = issueTypeSchemeManager;
    }

    @GET
    @Path(value="project/{projectIdOrKey}")
    public Response getIssueTypesForProject(@PathParam(value="projectIdOrKey") String projectIdOrKey) {
        Project project = org.apache.commons.lang3.StringUtils.isNumeric((CharSequence)projectIdOrKey) ? this.projectManager.getProjectObj(Long.valueOf(projectIdOrKey)) : this.projectManager.getProjectObjByKey(projectIdOrKey);
        if (project == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok(this.toBeans(this.issueTypeSchemeManager.getIssueTypesForProject(project))).cacheControl(CacheControl.never()).build();
    }

    @GET
    public Response getAllTypes() {
        return Response.ok(this.toBeans(this.constantsManager.getAllIssueTypeObjects())).cacheControl(CacheControl.never()).build();
    }

    private List<IssueTypeBean> toBeans(Collection<IssueType> issueTypes) {
        return issueTypes.stream().map(IssueTypeBean::new).collect(Collectors.toList());
    }

    @POST
    public Response createIssueType(IssueTypeBean bean) {
        String style = bean.subtask ? SUBTASK : TASK;
        SimpleErrorCollection collections = new SimpleErrorCollection();
        this.constantsManager.validateCreateIssueType(bean.name, style, bean.description, bean.iconUrl, (ErrorCollection)collections, "name");
        if (collections.hasAnyErrors()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(CacheControl.never()).entity((Object)Errors.of((ErrorCollection)collections)).build();
        }
        IssueType type = bean.subtask ? this.issueTypeManager.createSubTaskIssueType(bean.name, bean.description, bean.iconUrl) : this.issueTypeManager.createIssueType(bean.name, bean.description, bean.iconUrl);
        return Response.ok((Object)new IssueTypeBean(type)).cacheControl(CacheControl.never()).build();
    }

    @DELETE
    @Path(value="{id}")
    public Response deleteIssueType(@PathParam(value="id") long id) {
        this.issueTypeManager.removeIssueType(String.valueOf(id), null);
        return Response.ok().cacheControl(CacheControl.never()).build();
    }

    public static class IssueTypeBean {
        @JsonProperty
        private String id;
        @JsonProperty
        private String description;
        @JsonProperty
        private String iconUrl;
        @JsonProperty
        private String name;
        @JsonProperty
        private boolean subtask;

        public IssueTypeBean() {
        }

        public IssueTypeBean(IssueType type) {
            this.id = StringUtils.trimToNull((String)type.getId());
            this.name = StringUtils.trimToNull((String)type.getName());
            this.iconUrl = StringUtils.trimToNull((String)type.getIconUrl());
            this.description = StringUtils.trimToNull((String)type.getDescription());
            this.subtask = type.isSubTask();
        }
    }
}

