/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.plugin;

import com.atlassian.jira.config.ResolutionManager;
import com.atlassian.jira.testkit.beans.Resolution;
import com.atlassian.jira.testkit.plugin.util.CacheControl;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;

@Path(value="resolution")
@AnonymousAllowed
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class ResolutionBackdoorResource {
    private final ResolutionManager resolutionManager;

    public ResolutionBackdoorResource(ResolutionManager resolutionManager) {
        this.resolutionManager = resolutionManager;
    }

    @GET
    public Response getAllResolutions() {
        ArrayList resolutionBeans = Lists.newArrayList();
        for (com.atlassian.jira.issue.resolution.Resolution resolution : this.resolutionManager.getResolutions()) {
            resolutionBeans.add(this.create(resolution));
        }
        return Response.ok((Object)resolutionBeans).cacheControl(CacheControl.never()).build();
    }

    @POST
    public Response createResolution(Resolution bean) {
        com.atlassian.jira.issue.resolution.Resolution resolution = this.resolutionManager.createResolution(bean.getName(), bean.getDescription());
        return Response.ok((Object)this.create(resolution)).cacheControl(CacheControl.never()).build();
    }

    @PUT
    public Response updateResolution(Resolution bean) {
        com.atlassian.jira.issue.resolution.Resolution resolution = this.resolutionManager.getResolution(bean.getId());
        this.resolutionManager.editResolution(resolution, bean.getName(), bean.getDescription());
        return Response.ok((Object)this.create(resolution)).cacheControl(CacheControl.never()).build();
    }

    @DELETE
    @Path(value="{id}")
    public Response deleteResolution(@PathParam(value="id") long id) {
        this.resolutionManager.removeResolution(String.valueOf(id), this.resolutionManager.getDefaultResolution().getId());
        return Response.ok().cacheControl(CacheControl.never()).build();
    }

    @POST
    @Path(value="{id}/up")
    public Response moveUp(@PathParam(value="id") long id) {
        this.resolutionManager.moveResolutionUp(String.valueOf(id));
        return Response.ok().cacheControl(CacheControl.never()).build();
    }

    @POST
    @Path(value="{id}/down")
    public Response moveDown(@PathParam(value="id") long id) {
        this.resolutionManager.moveResolutionDown(String.valueOf(id));
        return Response.ok().cacheControl(CacheControl.never()).build();
    }

    @POST
    @Path(value="{id}/default")
    public Response setDefault(@PathParam(value="id") long id) {
        this.resolutionManager.setDefaultResolution(String.valueOf(id));
        return Response.ok().cacheControl(CacheControl.never()).build();
    }

    private Resolution create(com.atlassian.jira.issue.resolution.Resolution resolution) {
        return new Resolution(StringUtils.trimToNull((String)resolution.getId()), StringUtils.trimToNull((String)resolution.getName()), StringUtils.trimToNull((String)resolution.getDescription()), resolution.getSequence());
    }
}

