/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.plugin;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.testkit.plugin.util.CacheControl;
import com.atlassian.jira.util.JiraDurationUtils;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;

@Path(value="timeTracking")
@AnonymousAllowed
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class TimeTrackingBackdoor {
    private final ApplicationProperties applicationProperties;
    private final JiraDurationUtils jiraDurationUtils;
    private final FieldManager fieldManager;
    private final JiraAuthenticationContext authenticationContext;

    public TimeTrackingBackdoor(ApplicationProperties applicationProperties, FieldManager fieldManager, JiraAuthenticationContext authenticationContext) {
        this.applicationProperties = applicationProperties;
        this.jiraDurationUtils = (JiraDurationUtils)ComponentAccessor.getComponentOfType(JiraDurationUtils.class);
        this.fieldManager = fieldManager;
        this.authenticationContext = authenticationContext;
    }

    @GET
    @Path(value="enable")
    public Response enable(@QueryParam(value="hoursPerDay") String hoursPerDay, @QueryParam(value="daysPerWeek") String daysPerWeek, @QueryParam(value="format") String format, @QueryParam(value="unit") String unit, @QueryParam(value="legacy") String legacy) {
        this.applicationProperties.setOption("jira.option.timetracking", true);
        this.applicationProperties.setString("jira.timetracking.hours.per.day", hoursPerDay);
        this.applicationProperties.setString("jira.timetracking.days.per.week", daysPerWeek);
        this.applicationProperties.setString("jira.timetracking.format", format);
        this.applicationProperties.setString("jira.timetracking.default.unit", StringUtils.upperCase((String)unit));
        this.applicationProperties.setOption("jira.timetracking.estimates.legacy.behaviour", Boolean.valueOf(legacy).booleanValue());
        this.jiraDurationUtils.updateFormatters(this.applicationProperties, this.authenticationContext);
        this.fieldManager.refresh();
        return Response.ok().cacheControl(CacheControl.never()).build();
    }
}

