/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.plugin;

import com.atlassian.annotations.security.XsrfProtectionExcluded;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.exception.InvalidMembershipException;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.exception.embedded.InvalidGroupException;
import com.atlassian.crowd.exception.runtime.UserNotFoundException;
import com.atlassian.jira.bc.security.login.LoginInfo;
import com.atlassian.jira.bc.security.login.LoginService;
import com.atlassian.jira.bc.user.UserService;
import com.atlassian.jira.exception.AddException;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.testkit.beans.DirectoryDTO;
import com.atlassian.jira.testkit.beans.LoginInfoBean;
import com.atlassian.jira.testkit.beans.UserDTO;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="usersAndGroups")
public class UsersAndGroupsBackdoor {
    private static final Logger log = LoggerFactory.getLogger(UsersAndGroupsBackdoor.class);
    private static final Response NOT_FOUND = Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    private static final Response OK = Response.ok().build();
    private final CrowdService crowdService;
    private final LoginService loginService;
    private final UserUtil userUtil;
    private final GroupManager groupManager;
    private final UserManager userManager;
    private final CrowdDirectoryService crowdDirectoryService;
    private final UserService userService;

    public UsersAndGroupsBackdoor(UserUtil userUtil, CrowdService crowdService, LoginService loginService, GroupManager groupManager, UserManager userManager, CrowdDirectoryService crowdDirectoryService, UserService userService) {
        this.crowdService = crowdService;
        this.userUtil = userUtil;
        this.loginService = loginService;
        this.groupManager = groupManager;
        this.userManager = userManager;
        this.crowdDirectoryService = crowdDirectoryService;
        this.userService = userService;
    }

    @GET
    @AnonymousAllowed
    @Path(value="user/addEvenIfUserExists")
    public Response addEvenIfuserExists(@QueryParam(value="userName") String username, @QueryParam(value="password") String password, @QueryParam(value="email") String email, @QueryParam(value="displayName") String displayName, @QueryParam(value="sendEmail") boolean sendEmail) {
        if (this.userUtil.userExists(username)) {
            this.deleteUser(username);
        }
        return this.addUser(username, password, email, displayName, sendEmail);
    }

    @GET
    @AnonymousAllowed
    @Path(value="user/add")
    public Response addUser(@QueryParam(value="userName") String username, @QueryParam(value="password") String password, @QueryParam(value="email") String email, @QueryParam(value="displayName") String displayName, @QueryParam(value="sendEmail") boolean sendEmail) {
        try {
            this.doAddUser(username, password, email, displayName, sendEmail);
        }
        catch (PermissionException e) {
            log.warn("PermissionException adding user", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (CreateException e) {
            log.warn("CreateException adding user", (Throwable)e);
            throw new RuntimeException(e);
        }
        return Response.ok(null).build();
    }

    private void doAddUser(String username, String password, String email, String displayName, boolean sendEmail) throws PermissionException, CreateException {
        UserService.CreateUserRequest createUserRequest = UserService.CreateUserRequest.withUserDetails(null, (String)username, (String)password, (String)email, (String)displayName).sendNotification(sendEmail).skipValidation();
        this.userService.createUser(this.userService.validateCreateUser(createUserRequest));
    }

    @GET
    @AnonymousAllowed
    @Path(value="user/delete")
    public Response deleteUser(@QueryParam(value="userName") String username) {
        ApplicationUser admin = this.userUtil.getUserByName("admin");
        ApplicationUser userToRemove = this.userUtil.getUserByName(username);
        this.userUtil.removeUser(admin, userToRemove);
        return Response.ok(null).build();
    }

    @GET
    @AnonymousAllowed
    @Path(value="user/addToGroup")
    public Response addUserToGroup(@QueryParam(value="userName") String userName, @QueryParam(value="groupName") String groupName) {
        Group group = this.crowdService.getGroup(groupName);
        ApplicationUser userToAdd = this.userUtil.getUserByName(userName);
        try {
            this.userUtil.addUserToGroup(group, userToAdd);
        }
        catch (PermissionException e) {
            log.warn("PermissionException adding user to group", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (AddException e) {
            log.warn("PermissionException adding user to group", (Throwable)e);
            throw new RuntimeException(e);
        }
        return Response.ok(null).build();
    }

    @GET
    @AnonymousAllowed
    @Path(value="user/removeFromGroup")
    public Response removeUserFromGroup(@QueryParam(value="userName") String userName, @QueryParam(value="groupName") String groupName) {
        Group group = this.crowdService.getGroup(groupName);
        ApplicationUser userToRemove = this.userUtil.getUserByName(userName);
        try {
            this.userUtil.removeUserFromGroup(group, userToRemove);
        }
        catch (PermissionException e) {
            log.warn("PermissionException removing user from group", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (RemoveException e) {
            log.warn("RemoveExceptionNotPermittedException removing user from group", (Throwable)e);
            throw new RuntimeException(e);
        }
        return Response.ok(null).build();
    }

    @GET
    @AnonymousAllowed
    @Path(value="group/add")
    public Response addGroup(@QueryParam(value="groupName") String groupName) {
        try {
            this.crowdService.addGroup((Group)new GroupTemplate(groupName));
        }
        catch (InvalidGroupException e) {
            log.warn("InvalidGroupException adding group", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (OperationNotPermittedException e) {
            log.warn("OperationNotPermittedException adding group", (Throwable)e);
            throw new RuntimeException(e);
        }
        return Response.ok(null).build();
    }

    @GET
    @AnonymousAllowed
    @Path(value="group/exists")
    public Response groupExists(@QueryParam(value="groupName") String groupName) {
        boolean exists = this.crowdService.getGroup(groupName) != null;
        return Response.ok((Object)Boolean.toString(exists)).build();
    }

    @GET
    @AnonymousAllowed
    @Path(value="group/delete")
    public Response deleteGroup(@QueryParam(value="groupName") String groupName) {
        try {
            this.crowdService.removeGroup((Group)new GroupTemplate(groupName));
        }
        catch (OperationNotPermittedException e) {
            log.warn("OperationNotPermittedException adding group", (Throwable)e);
            throw new RuntimeException(e);
        }
        return Response.ok(null).build();
    }

    @GET
    @AnonymousAllowed
    @Path(value="group/addToGroup")
    public Response addGroupToGroup(@QueryParam(value="groupName") String groupName, @QueryParam(value="parentGroupName") String parentGroupName) {
        Group childGroup = this.crowdService.getGroup(groupName);
        Group parentGroup = this.crowdService.getGroup(parentGroupName);
        try {
            this.crowdService.addGroupToGroup(childGroup, parentGroup);
        }
        catch (InvalidMembershipException | OperationNotPermittedException e) {
            log.warn("Exception adding group to group", e);
            throw new RuntimeException(e);
        }
        return Response.ok(null).build();
    }

    @GET
    @AnonymousAllowed
    @Path(value="group/addMany")
    public Response addManyGroups(@QueryParam(value="groupNamePrefix") String groupNamePrefix, @QueryParam(value="numberOfNewGroups") int numberOfNewGroups, @Nullable @QueryParam(value="parentGroupName") String parentGroupName, @Nullable @QueryParam(value="numberOfNewUsersPerGroup") Integer numberOfNewUsers) {
        Group parentGroup = null;
        if (StringUtils.isNotBlank((String)parentGroupName)) {
            parentGroup = this.crowdService.getGroup(parentGroupName);
        }
        try {
            for (int i = 0; i < numberOfNewGroups; ++i) {
                String groupName = groupNamePrefix + i;
                Group newGroup = this.crowdService.addGroup((Group)new GroupTemplate(groupName));
                if (parentGroup != null) {
                    this.crowdService.addGroupToGroup(newGroup, parentGroup);
                }
                if (numberOfNewUsers == null || numberOfNewUsers <= 0) continue;
                String prefix = groupName + "-user";
                this.addManyUsers(prefix, prefix, numberOfNewUsers, newGroup.getName());
            }
        }
        catch (InvalidMembershipException | OperationNotPermittedException | InvalidGroupException e) {
            log.warn("Exception adding groups", e);
            throw new RuntimeException(e);
        }
        return Response.ok(null).build();
    }

    @GET
    @AnonymousAllowed
    @Path(value="user/addMany")
    public Response addManyUsers(@QueryParam(value="usernamePrefix") String usernamePrefix, @QueryParam(value="displayNamePrefix") String displayNamePrefix, @QueryParam(value="numberOfNewUsers") int numberOfNewUsers, @Nullable @QueryParam(value="groupName") String groupName) {
        Group group = null;
        if (StringUtils.isNotBlank((String)groupName)) {
            group = this.crowdService.getGroup(groupName);
        }
        try {
            for (int i = 0; i < numberOfNewUsers; ++i) {
                String username = usernamePrefix + i;
                this.doAddUser(username, username, "e" + username + "@example.com", displayNamePrefix + i, false);
                if (group == null) continue;
                ApplicationUser user = this.userUtil.getUserByName(username);
                this.userUtil.addUserToGroup(group, user);
            }
        }
        catch (PermissionException e) {
            log.warn("Permission exception adding users", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (CreateException e) {
            log.warn("Create exception adding users", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (AddException e) {
            log.warn("Add exception adding users", (Throwable)e);
            throw new RuntimeException(e);
        }
        return Response.ok(null).build();
    }

    @GET
    @AnonymousAllowed
    @Path(value="user/resetLoginCount")
    public Response resetLoginCount(@QueryParam(value="user") String username) {
        ApplicationUser user = this.userUtil.getUserByName(username);
        this.loginService.resetFailedLoginCount(user);
        return Response.ok(null).build();
    }

    @GET
    @AnonymousAllowed
    @Path(value="user/count")
    public Response numberOfUsers() {
        String count = Long.toString(this.userUtil.getTotalUserCount());
        return Response.ok((Object)count).build();
    }

    @GET
    @AnonymousAllowed
    @Path(value="group/count")
    public Response numberOfGroups() {
        int count = this.groupManager.getAllGroups().size();
        String stringCount = Long.toString(count);
        return Response.ok((Object)stringCount).build();
    }

    @GET
    @AnonymousAllowed
    @Path(value="group/includes")
    @Produces(value={"application/json"})
    public Response groupIncludes(@QueryParam(value="groupName") String groupName, @QueryParam(value="userName") String userName) {
        return Response.ok((Object)this.userUtil.getGroupNamesForUser(userName).contains(groupName)).build();
    }

    @GET
    @AnonymousAllowed
    @Path(value="user/exists")
    @Produces(value={"application/json"})
    public Response userExists(@QueryParam(value="userName") String userName) {
        return Response.ok((Object)this.userUtil.userExists(userName)).build();
    }

    @GET
    @AnonymousAllowed
    @Path(value="user/loginInfo")
    @Produces(value={"application/json"})
    public Response loginInfo(@QueryParam(value="userName") String userName) {
        LoginInfo info = this.loginService.getLoginInfo(userName);
        if (info == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("No user '" + userName + "' found")).build();
        }
        LoginInfoBean bean = new LoginInfoBean();
        bean.setLoginCount(UsersAndGroupsBackdoor.nullToZero(info.getLoginCount()));
        bean.setCurrentFailedLoginCount(UsersAndGroupsBackdoor.nullToZero(info.getCurrentFailedLoginCount()));
        bean.setTotalFailedLoginCount(UsersAndGroupsBackdoor.nullToZero(info.getTotalFailedLoginCount()));
        return Response.ok((Object)bean).build();
    }

    @GET
    @AnonymousAllowed
    @Path(value="user/byName")
    @Produces(value={"application/json"})
    public Response getUserByName(@QueryParam(value="userName") String userName) {
        ApplicationUser user = this.userUtil.getUserByName(userName);
        if (user == null) {
            return NOT_FOUND;
        }
        return Response.ok((Object)new UserDTO(user)).build();
    }

    @GET
    @AnonymousAllowed
    @Path(value="user/byNameEvenWhenUnknown")
    @Produces(value={"application/json"})
    public Response getUserByNameEvenWhenUnknown(@QueryParam(value="userName") String userName) {
        ApplicationUser user = this.userManager.getUserByNameEvenWhenUnknown(userName);
        if (user == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Passed username was null").build();
        }
        return Response.ok((Object)new UserDTO(user)).build();
    }

    @GET
    @AnonymousAllowed
    @Path(value="user/all")
    @Produces(value={"application/json"})
    public Response getAllUsers() {
        return Response.ok((Object)Collections2.transform((Collection)this.userManager.getAllApplicationUsers(), user -> new UserDTO((ApplicationUser)user))).build();
    }

    @POST
    @AnonymousAllowed
    @Path(value="user/byName")
    @XsrfProtectionExcluded
    public Response updateUser(UserDTO user) {
        ApplicationUser existingUser;
        if (log.isDebugEnabled()) {
            log.debug("Updating user with: " + user);
        }
        if ((existingUser = this.userManager.getUserByKey(user.getKey())) == null) {
            return NOT_FOUND;
        }
        ApplicationUser updatedUser = user.asApplicationUser(existingUser.getDirectoryUser());
        try {
            this.userManager.updateUser(updatedUser);
        }
        catch (UserNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)e.getMessage()).build();
        }
        return OK;
    }

    @GET
    @AnonymousAllowed
    @Path(value="directory")
    @Produces(value={"application/json"})
    public Response getAllDirectories() {
        return Response.ok((Object)Lists.transform((List)this.crowdDirectoryService.findAllDirectories(), directory -> new DirectoryDTO((Directory)directory))).build();
    }

    @GET
    @AnonymousAllowed
    @Path(value="directory/{id}")
    @Produces(value={"application/json"})
    public Response getDirectory(@PathParam(value="id") long id) {
        return Response.ok((Object)new DirectoryDTO(this.crowdDirectoryService.findDirectoryById(id))).build();
    }

    private static long nullToZero(Long theLong) {
        return theLong != null ? theLong : 0L;
    }

    private static class GroupTemplate
    implements Group {
        private final String groupName;

        public GroupTemplate(String groupName) {
            this.groupName = groupName;
        }

        public String getName() {
            return this.groupName;
        }

        public int compareTo(Group o) {
            return this.groupName.compareTo(o.getName());
        }
    }
}

