/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.plugin;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityFieldMap;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericValue;

@Path(value="worklog")
@AnonymousAllowed
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class WorklogBackdoorResource {
    @Path(value="updatedtime")
    @PUT
    public Response setUpdatedTime(@QueryParam(value="worklogId") Long worklogId, @QueryParam(value="timestamp") Long timestamp) {
        OfBizDelegator ofBizDelegator = ComponentAccessor.getOfBizDelegator();
        GenericValue worklog = ofBizDelegator.findById("Worklog", worklogId);
        if (worklog.get("updated") == null) {
            throw new AssertionError((Object)"Updated field was expected to be filled");
        }
        ofBizDelegator.bulkUpdateByPrimaryKey("Worklog", (Map)ImmutableMap.of((Object)"updated", (Object)new Timestamp(timestamp)), (List)Lists.newArrayList((Object[])new Long[]{worklogId}));
        return Response.ok().build();
    }

    @Path(value="deletedtime")
    @PUT
    public Response setDeletedChangeGroupTime(final @QueryParam(value="worklogId") Long worklogId, @QueryParam(value="timestamp") Long timestamp) {
        OfBizDelegator ofBizDelegator = ComponentAccessor.getOfBizDelegator();
        List result = ofBizDelegator.findByCondition("ChangeItem", (EntityCondition)new EntityFieldMap((Map)FieldMap.build((String)"field", (Object)"WorklogId"), EntityOperator.AND), (Collection)Lists.newArrayList((Object[])new String[]{"group", "oldvalue"}));
        ArrayList genericValues = Lists.newArrayList((Iterable)result);
        Iterable filtered = Iterables.filter((Iterable)genericValues, (Predicate)new Predicate<GenericValue>(){

            public boolean apply(GenericValue genericValue) {
                return genericValue.get("oldvalue").equals(worklogId.toString());
            }
        });
        Iterable groups = Iterables.transform((Iterable)filtered, (Function)new Function<GenericValue, Long>(){

            public Long apply(GenericValue genericValue) {
                return genericValue.getLong("group");
            }
        });
        ofBizDelegator.bulkUpdateByPrimaryKey("ChangeGroup", (Map)ImmutableMap.of((Object)"created", (Object)new Timestamp(timestamp)), (List)Lists.newArrayList((Iterable)groups));
        return Response.ok().build();
    }
}

