/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.plugin.util;

import com.atlassian.jira.util.ErrorCollection;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

@XmlRootElement
public class Errors {
    @XmlElement
    private Collection<String> errorMessages = Lists.newArrayList();
    @XmlElement
    private Map<String, String> errors = Maps.newHashMap();
    private Integer status = null;

    public static Errors of(String ... messages) {
        return Errors.of(Arrays.asList(messages));
    }

    public static Errors of(Collection<String> messages) {
        return new Errors().addErrorMessages(messages);
    }

    public static Errors of(ErrorCollection errorCollection) {
        return new Errors().addErrorCollection(errorCollection);
    }

    public Errors addErrorCollection(ErrorCollection errorCollection) {
        this.errorMessages.addAll(((ErrorCollection)Preconditions.checkNotNull((Object)errorCollection)).getErrorMessages());
        this.errors.putAll(errorCollection.getErrors());
        this.reason(ErrorCollection.Reason.getWorstReason((Collection)errorCollection.getReasons()));
        return this;
    }

    public Errors addErrorMessage(String errorMessage) {
        this.errorMessages.add((String)Preconditions.checkNotNull((Object)errorMessage));
        return this;
    }

    public Errors addErrorMessages(Collection<String> messages) {
        this.errorMessages.addAll((Collection)Preconditions.checkNotNull(messages));
        return this;
    }

    public boolean hasAnyErrors() {
        return !this.errorMessages.isEmpty() || !this.errors.isEmpty();
    }

    public Collection<String> getErrorMessages() {
        return this.errorMessages;
    }

    public Map<String, String> getErrors() {
        return this.errors;
    }

    public Errors reason(ErrorCollection.Reason reason) {
        this.status = reason == null ? Response.Status.BAD_REQUEST.getStatusCode() : reason.getHttpStatusCode();
        return this;
    }

    public Integer getStatus() {
        return this.status;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

