/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.plugin.workflows;

import com.atlassian.jira.config.IssueTypeManager;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.scheme.SchemeEntity;
import com.atlassian.jira.testkit.beans.WorkflowSchemeData;
import com.atlassian.jira.testkit.plugin.workflows.WorkflowSchemeDataFactory;
import com.atlassian.jira.workflow.AssignableWorkflowScheme;
import com.atlassian.jira.workflow.DraftWorkflowScheme;
import com.atlassian.jira.workflow.WorkflowScheme;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.google.common.base.Function;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class WorkflowSchemeDataFactoryImpl
implements WorkflowSchemeDataFactory {
    private final IssueTypeManager issueTypeManager;
    private final WorkflowSchemeManager workflowSchemeManager;
    private final DateTimeFormatter formatter;

    WorkflowSchemeDataFactoryImpl(IssueTypeManager issueTypeManager, WorkflowSchemeManager workflowSchemeManager, DateTimeFormatter formatter) {
        this.issueTypeManager = issueTypeManager;
        this.workflowSchemeManager = workflowSchemeManager;
        this.formatter = formatter.withStyle(DateTimeStyle.RELATIVE).withLocale(Locale.ENGLISH);
    }

    @Override
    public WorkflowSchemeData toData(WorkflowScheme scheme) {
        String defaultWorkflow = null;
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : scheme.getMappings().entrySet()) {
            String key = (String)entry.getKey();
            if (key != null) {
                key = this.issueTypeManager.getIssueType(key).getName();
                map.put(key, entry.getValue());
                continue;
            }
            defaultWorkflow = (String)entry.getValue();
        }
        WorkflowSchemeData data = new WorkflowSchemeData().setId(scheme.getId()).setName(scheme.getName()).setDescription(scheme.getDescription()).setMappings(map).setDefaultWorkflow(defaultWorkflow).setDraft(scheme.isDraft()).setActive(this.workflowSchemeManager.isActive(scheme));
        if (scheme instanceof DraftWorkflowScheme) {
            DraftWorkflowScheme draftWorkflowScheme = (DraftWorkflowScheme)scheme;
            data.setLastModified(this.formatter.format(draftWorkflowScheme.getLastModifiedDate()));
            data.setLastModifiedUser(draftWorkflowScheme.getLastModifiedUser().getName());
        }
        return data;
    }

    @Override
    public WorkflowSchemeData toData(Scheme scheme) {
        HashMap mappings = Maps.newHashMap();
        Collection entities = scheme.getEntities();
        String defaultWorkflow = null;
        for (SchemeEntity entity : entities) {
            String parameter = entity.getParameter();
            if (parameter == null || "0".equals(parameter)) {
                defaultWorkflow = entity.getEntityTypeId().toString();
                continue;
            }
            IssueType object = this.issueTypeManager.getIssueType(parameter);
            mappings.put(object.getName(), entity.getEntityTypeId().toString());
        }
        if (defaultWorkflow == null) {
            defaultWorkflow = "jira";
        }
        return new WorkflowSchemeData().setId(scheme.getId()).setName(scheme.getName()).setDescription(scheme.getDescription()).setMappings(mappings).setDefaultWorkflow(defaultWorkflow).setDraft(false).setActive(this.workflowSchemeManager.getProjects(scheme).isEmpty());
    }

    Function<Scheme, WorkflowSchemeData> fromSchemeToDataFunction() {
        return new Function<Scheme, WorkflowSchemeData>(){

            public WorkflowSchemeData apply(Scheme scheme) {
                return WorkflowSchemeDataFactoryImpl.this.toData(scheme);
            }
        };
    }

    AssignableWorkflowScheme schemeFromData(WorkflowSchemeData data, AssignableWorkflowScheme.Builder current) {
        AssignableWorkflowScheme.Builder builder = current.setName(data.getName()).setDescription(data.getDescription());
        this.setMappings(data, (WorkflowScheme.Builder<?>)current);
        return builder.build();
    }

    DraftWorkflowScheme draftFromData(WorkflowSchemeData data, DraftWorkflowScheme current) {
        DraftWorkflowScheme.Builder builder = (DraftWorkflowScheme.Builder)current.builder().clearMappings();
        this.setMappings(data, (WorkflowScheme.Builder<?>)builder);
        return builder.build();
    }

    private void setMappings(WorkflowSchemeData data, WorkflowScheme.Builder<?> builder) {
        builder.clearMappings();
        if (data.getDefaultWorkflow() != null) {
            builder.setDefaultWorkflow(data.getDefaultWorkflow());
        }
        for (Map.Entry<String, String> entry : data.getMappings().entrySet()) {
            builder.setMapping(this.findIssueType(entry.getKey()), entry.getValue());
        }
    }

    private String findIssueType(String type) {
        IssueType obj = this.issueTypeManager.getIssueType(type);
        if (obj == null) {
            for (IssueType issueType : this.issueTypeManager.getIssueTypes()) {
                if (!issueType.getName().equals(type)) continue;
                obj = issueType;
                break;
            }
        }
        if (obj == null) {
            throw new IllegalArgumentException("Unable to find IssueType with id or name of '" + type + "'.");
        }
        return obj.getId();
    }
}

