package com.atlassian.mail;

import com.atlassian.annotations.tenancy.TenancyScope;
import com.atlassian.annotations.tenancy.TenantAware;
import com.atlassian.mail.config.ConfigLoader;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.mail.server.auth.AuthenticationContextFactory;
import io.atlassian.util.concurrent.ResettableLazyReference;

public class MailFactory {
    /**
     * @deprecated since 2.5.0. Use {@link Settings#ATLASSIAN_MAIL_SEND_DISABLED_SYSTEM_PROPERTY_KEY} instead.
     */
    @Deprecated
    public static final String MAIL_DISABLED_KEY = "atlassian.mail.senddisabled";

    @TenantAware(value = TenancyScope.TENANTLESS, comment = "This stores a value loaded from a file on disk that will " +
            "always be the same in Vertigo")
    private static final ResettableLazyReference<ConfigLoader> configLoader =
            new ResettableLazyReference<ConfigLoader>() {
                @Override
                protected ConfigLoader create() throws Exception {
                    return ConfigLoader.getImmutableConfigurationLoader();
                }
    };
    
    public static void refresh() {
        configLoader.reset();
    }

    public static MailServerManager getServerManager() {
        return configLoader.get().getLoadedManager();
    }

    public static Settings getSettings() {
        return configLoader.get().getLoadedSettings();
    }

    public static AuthenticationContextFactory getAuthenticationContextFactory() {
        return configLoader.get().getLoadedAuthContextFactory();
    }

    /**
     * @deprecated since 2.5.0. Use {@link com.atlassian.mail.Settings#isSendingDisabled()} instead
     */
    @Deprecated
    public static boolean isSendingDisabled() {
        return getSettings().isSendingDisabled();
    }
}
