package com.atlassian.mail.server;

import com.atlassian.mail.server.auth.AuthenticationContext;
import com.atlassian.mail.server.auth.AuthenticationContextFactory;
import com.atlassian.mail.server.auth.Credentials;
import com.atlassian.mail.server.auth.UserPasswordCredentials;

/**
 * Default factory for authentication context - it supports user/password credentials only
 */
public class DefaultAuthContextFactory implements AuthenticationContextFactory {

    private static volatile DefaultAuthContextFactory instance;

    public static DefaultAuthContextFactory getInstance() {
        if (instance == null) {
            synchronized (DefaultAuthContextFactory.class) {
                if (instance == null) {
                    instance = new DefaultAuthContextFactory();
                }
            }
        }
        return instance;
    }

    @Override
    public AuthenticationContext createAuthenticationContext(final Credentials credentials) {
        if (credentials instanceof UserPasswordCredentials) {
            final UserPasswordCredentials userPassword = (UserPasswordCredentials) credentials;
            return this.createAuthenticationContext(userPassword.getUserName(), userPassword.getPassword());
        }
        return null;
    }

    AuthenticationContext createAuthenticationContext(final String userName, final String password) {
        return new InternalAuthenticationContext(userName, password);
    }

    AuthenticationContext createAuthenticationContext() {
        return new InternalAuthenticationContext();
    }
}
