/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import com.atlassian.maven.plugins.amps.BannedDependencies;
import com.atlassian.maven.plugins.amps.MavenContext;
import com.atlassian.maven.plugins.amps.MavenGoals;
import com.atlassian.maven.plugins.amps.PluginInformation;
import com.atlassian.maven.plugins.amps.pdk.PluginInstaller;
import com.atlassian.maven.plugins.amps.util.AmpsPluginVersionChecker;
import com.atlassian.maven.plugins.amps.util.MojoExecutorWrapper;
import com.atlassian.maven.plugins.amps.util.ProjectUtils;
import com.atlassian.maven.plugins.amps.util.UpdateChecker;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class AbstractAmpsMojo
extends AbstractMojo {
    @Component
    private AmpsPluginVersionChecker ampsPluginVersionChecker;
    @Component
    private BuildPluginManager buildPluginManager;
    @Component
    protected MojoExecutorWrapper mojoExecutorWrapper;
    @Component
    private UpdateChecker updateChecker;
    @Component
    private BannedDependencies bannedDependencies;
    @VisibleForTesting
    MavenContext mavenContext;
    @VisibleForTesting
    MavenGoals mavenGoals;
    @VisibleForTesting
    PluginInstaller pluginInstaller;
    @Parameter(property="project", required=true, readonly=true)
    private MavenProject project;
    @Parameter(property="reactorProjects", required=true, readonly=true)
    private List<MavenProject> reactor;
    @Parameter(property="session", required=true, readonly=true)
    private MavenSession session;
    @Parameter(property="plugin.artifactId", required=true, readonly=true)
    private String pluginArtifactId;
    @Parameter(property="plugin.version", required=true, readonly=true)
    private String pluginVersion;
    @Parameter(property="force.update.check", defaultValue="false")
    private boolean forceUpdateCheck;
    @Parameter(property="skip.amps.pom.check", defaultValue="false")
    private boolean skipAmpsPomCheck;
    @Parameter(property="js.compiler.skip.minified", defaultValue="false")
    protected boolean skipMinifiedJs;
    @Parameter(property="skipAllPrompts", defaultValue="false")
    private boolean skipAllPrompts;
    @Parameter(property="buildTestPlugin", defaultValue="false")
    private boolean buildTestPlugin;
    @Parameter(property="offline", defaultValue="${settings.offline}")
    protected boolean offline;
    @Deprecated
    @Parameter(property="version.override.path")
    private String versionOverridesPath;
    @Parameter(property="version.override.set")
    private Set<String> versionOverrides;
    @Parameter(property="encoding", defaultValue="${project.build.sourceEncoding}")
    protected String encoding;

    protected MavenContext getMavenContext() {
        if (this.mavenContext == null) {
            this.mavenContext = new MavenContext(this.project, this.reactor, this.session, this.buildPluginManager, this.getLog());
        }
        this.mavenContext.setVersionOverridesPath(this.versionOverridesPath);
        this.mavenContext.setVersionOverrides(this.versionOverrides);
        return this.mavenContext;
    }

    protected final MavenGoals getMavenGoals() {
        if (this.mavenGoals == null) {
            this.mavenGoals = new MavenGoals(this.getMavenContext(), this.mojoExecutorWrapper, this.bannedDependencies);
        }
        return this.mavenGoals;
    }

    protected final PluginInstaller getPluginInstaller() {
        if (this.pluginInstaller == null) {
            this.pluginInstaller = new PluginInstaller(this.getLog());
        }
        return this.pluginInstaller;
    }

    @Nonnull
    protected PluginInformation getPluginInformation() {
        String artifactId = this.pluginArtifactId == null ? "amps-maven-plugin" : this.pluginArtifactId;
        return PluginInformation.fromArtifactId(artifactId, this.pluginVersion);
    }

    protected final UpdateChecker getUpdateChecker() {
        this.updateChecker.setCurrentVersion(this.getSDKVersion());
        this.updateChecker.setForceCheck(this.forceUpdateCheck);
        boolean skipCheck = this.shouldSkipPrompts() || this.offline;
        this.updateChecker.setSkipCheck(skipCheck);
        return this.updateChecker;
    }

    protected final AmpsPluginVersionChecker getAmpsPluginVersionChecker() {
        this.ampsPluginVersionChecker.skipPomCheck(this.skipAmpsPomCheck);
        if (this.shouldSkipPrompts()) {
            this.ampsPluginVersionChecker.skipPomCheck(true);
        }
        return this.ampsPluginVersionChecker;
    }

    protected final String getAmpsPluginVersion() {
        String ampsPluginVersion = System.getenv("AMPS_PLUGIN_VERSION");
        return ampsPluginVersion == null ? this.getPluginInformation().getVersion() : ampsPluginVersion;
    }

    protected final String getSDKVersion() {
        String sdkVersion = System.getenv("ATLAS_VERSION");
        return sdkVersion != null ? sdkVersion : this.getPluginInformation().getVersion();
    }

    protected final boolean shouldBuildTestPlugin() {
        return this.buildTestPlugin || ProjectUtils.shouldDeployTestJar(this.getMavenContext());
    }

    protected final boolean shouldSkipPrompts() {
        return this.skipAllPrompts;
    }

    @VisibleForTesting
    protected void setMavenContext(MavenContext mavenContext) {
        this.mavenContext = mavenContext;
    }

    @VisibleForTesting
    protected void setMavenGoals(MavenGoals mavenGoals) {
        this.mavenGoals = mavenGoals;
    }

    protected Optional<String> getPropertyValue(String property, String propertyName, String fileProperty, String filePropertyName) throws MojoExecutionException {
        String prop = property;
        if (prop != null) {
            if (fileProperty != null) {
                this.getLog().info((CharSequence)("Both '" + propertyName + "' and '" + filePropertyName + "' properties were provided. Using '" + propertyName + "' value"));
            }
        } else if (fileProperty != null) {
            try {
                prop = new String(Files.readAllBytes(Paths.get(fileProperty, new String[0])), StandardCharsets.UTF_8);
            }
            catch (IOException ioe) {
                throw new MojoExecutionException(propertyName + " cannot be read from " + fileProperty + " : " + ioe.getMessage(), (Exception)ioe);
            }
        }
        return Optional.ofNullable(prop);
    }
}

