/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import com.atlassian.maven.plugins.amps.AbstractProductHandlerMojo;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.analytics.event.impl.AnalyticsEventFactory;
import com.atlassian.maven.plugins.amps.product.ProductHandler;
import com.atlassian.maven.plugins.amps.util.AmpsCreatePluginPrompter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.Properties;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="create", requiresProject=false)
public class CreateMojo
extends AbstractProductHandlerMojo {
    @Component
    private AmpsCreatePluginPrompter ampsCreatePluginPrompter;

    @Override
    protected void doExecute() throws MojoExecutionException {
        this.trackFirstRunIfNeeded();
        this.sendAnalyticsEvent(AnalyticsEventFactory.createPlugin());
        String pid = this.getProductId();
        Application a = this.getManualVersion(pid);
        Properties userProperties = this.getMavenContext().getExecutionEnvironment().getMavenSession().getUserProperties();
        if (a != null) {
            if (StringUtils.isNotBlank((CharSequence)a.latest)) {
                this.getLog().info((CharSequence)("using stable product version: " + a.latest));
                userProperties.setProperty(pid + "Version", a.latest);
            }
            if (StringUtils.isNotBlank((CharSequence)a.data)) {
                this.getLog().info((CharSequence)("using stable data version: " + a.data));
                userProperties.setProperty(pid + "DataVersion", a.data);
            }
        } else {
            Product product = this.getProductContexts().get(pid);
            this.getLog().info((CharSequence)"determining latest stable product version...");
            String stableVersion = this.getStableProductVersion(product);
            if (StringUtils.isNotBlank((CharSequence)stableVersion)) {
                this.getLog().info((CharSequence)("using latest stable product version: " + stableVersion));
                userProperties.setProperty(pid + "Version", stableVersion);
            }
            this.getLog().info((CharSequence)"determining latest stable data version...");
            String stableDataVersion = this.getStableDataVersion(product);
            if (StringUtils.isNotBlank((CharSequence)stableDataVersion)) {
                this.getLog().info((CharSequence)("using latest stable data version: " + stableDataVersion));
                userProperties.setProperty(pid + "DataVersion", stableDataVersion);
            }
        }
        this.getMavenGoals().createPlugin(this.getProductId(), this.ampsCreatePluginPrompter);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Application getManualVersion(String searchString) {
        XMLInputFactory f = XMLInputFactory.newInstance();
        f.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        try (InputStream versionsStream = CreateMojo.class.getClassLoader().getResourceAsStream("application-versions.xml");){
            XMLEventReader r = f.createXMLEventReader(versionsStream);
            Application a = new Application();
            String name = "";
            while (r.hasNext()) {
                XMLEvent e = r.nextEvent();
                switch (e.getEventType()) {
                    case 1: {
                        name = e.asStartElement().getName().getLocalPart();
                        if (!name.equalsIgnoreCase("application")) break;
                        a = new Application();
                        break;
                    }
                    case 2: {
                        if (e.asEndElement().getName().getLocalPart().equalsIgnoreCase("application") && a.name.equals(searchString)) {
                            Application application = a;
                            return application;
                        }
                        name = "";
                        break;
                    }
                    case 4: {
                        String value = e.asCharacters().getData().trim();
                        if (name.equalsIgnoreCase("name")) {
                            a.name = value;
                            break;
                        }
                        if (name.equalsIgnoreCase("latest")) {
                            a.latest = value;
                            break;
                        }
                        if (name.equalsIgnoreCase("data")) {
                            a.data = value;
                            break;
                        }
                        if (!name.equalsIgnoreCase("mvn-artifact")) break;
                        a.mvnArtifact = value;
                        break;
                    }
                }
            }
        }
        catch (IOException | XMLStreamException exception) {
            // empty catch block
        }
        return null;
    }

    protected final String getStableProductVersion(Product product) throws MojoExecutionException {
        ProductHandler handler = this.getProductHandler(product.getId());
        ProductArtifact artifact = handler.getArtifact();
        if (artifact == null) {
            return "";
        }
        Artifact warArtifact = this.repositorySystem.createProjectArtifact(artifact.getGroupId(), artifact.getArtifactId(), "LATEST");
        return product.getArtifactRetriever().getLatestStableVersion(warArtifact);
    }

    protected final String getStableDataVersion(Product product) throws MojoExecutionException {
        ProductHandler handler = this.getProductHandler(product.getId());
        Optional<ProductArtifact> maybeTestResourcesArtifact = handler.getTestResourcesArtifact();
        if (maybeTestResourcesArtifact.isPresent()) {
            ProductArtifact testResourcesArtifact = maybeTestResourcesArtifact.get();
            Artifact warArtifact = this.repositorySystem.createProjectArtifact(testResourcesArtifact.getGroupId(), testResourcesArtifact.getArtifactId(), "LATEST");
            return product.getArtifactRetriever().getLatestStableVersion(warArtifact);
        }
        return "";
    }

    private static class Application {
        String name = "";
        String latest = "";
        String data = "";
        String mvnArtifact = "";

        private Application() {
        }

        public String toString() {
            return "name=" + this.name + " latest=" + this.latest + " data=" + this.data + " mvn-artifact=" + this.mvnArtifact;
        }
    }
}

