/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import com.atlassian.maven.plugins.amps.CustomCertificateBuilder;
import com.atlassian.upm.signing.tool.CustomCertificateProperties;
import com.atlassian.upm.signing.tool.UpmConfigHandler;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.nio.file.Path;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="create-upm-config")
public class CreateUpmConfigMojo
extends AbstractMojo {
    public static final String ATLASSIAN_UPM_CONFIGURATION_FILE = "atlassian.upm.configuration.file";
    public static final String ATLASSIAN_UPM_TRUSTSTORE_DIRECTORY = "atlassian.upm.truststore.directory";
    public static final String ATLASSIAN_UPM_CONFIGURATION_DIRECTORY = "atlassian.upm.configuration.directory";
    public static final String ATLASSIAN_UPM_CONFIG_LOOSECHECK_ALLOWED = "atlassian.upm.config.loosecheck.allowed";
    @Parameter(property="project.build.directory", required=true)
    protected File targetDirectory;
    @Parameter(property="enablePluginSigning", required=true, defaultValue="false")
    @VisibleForTesting
    private boolean enablePluginSigning;
    @Parameter(property="upmConfigReadonly", required=true, defaultValue="true")
    @VisibleForTesting
    protected boolean upmConfigReadonly;
    @Parameter(property="upmConfigPath")
    @VisibleForTesting
    private String upmConfigPath;
    @Parameter(property="upmConfigFile")
    @VisibleForTesting
    private String upmConfigFile;
    @Parameter(property="upmTrustStore")
    @VisibleForTesting
    private String upmTrustStore;
    @Parameter(property="overwriteUpmConfig", required=true, defaultValue="false")
    @VisibleForTesting
    private boolean overwriteUpmConfig;
    @Parameter(property="atlassianCertificates")
    @VisibleForTesting
    private String atlassianCertificates;
    @Parameter(property="customCertificate")
    private CustomCertificateBuilder customCertificate;

    public void execute() throws MojoExecutionException, MojoFailureException {
        UpmConfigHandler handler = UpmConfigHandler.builder((Path)this.targetDirectory.toPath()).enabled(this.enablePluginSigning).readonly(this.upmConfigReadonly).upmConfigPath(this.upmConfigPath).upmConfigFilePath(this.upmConfigFile).upmTrustStorePath(this.upmTrustStore).overwriteUpmConfig(this.overwriteUpmConfig).atlassianCertificates(this.atlassianCertificates).customCertificate((CustomCertificateProperties)this.customCertificate).build();
        handler.writeConfiguration();
        Map properties = handler.getSystemProperties();
        Log log = this.getLog();
        String singleRoot = (String)properties.get(ATLASSIAN_UPM_CONFIGURATION_DIRECTORY);
        String configFile = (String)properties.get(ATLASSIAN_UPM_CONFIGURATION_FILE);
        String truststore = (String)properties.get(ATLASSIAN_UPM_TRUSTSTORE_DIRECTORY);
        if (singleRoot != null) {
            log.info((CharSequence)("UPM configuration was written to " + singleRoot));
        } else {
            log.info((CharSequence)("UPM configuration file was written to " + configFile));
            log.info((CharSequence)("UPM truststore was created in directory " + truststore));
        }
        StringBuilder message = new StringBuilder("Add the following system properties on product startup to use this configuration : ");
        properties.forEach((key, value) -> message.append("\n\t").append((String)key).append("=").append((String)value));
        log.info((CharSequence)message.toString());
    }
}

