/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import com.atlassian.maven.plugins.amps.product.manager.BaseUrlUtils;
import java.io.File;

public class InstallParams {
    private static final String UPM_ROOT_RESOURCE = "/rest/plugins/1.0/";
    private final String pluginKey;
    private final String serverUrl;
    private final String username;
    private final String password;
    private final File pluginFile;
    private final String signature;

    private InstallParams(String pluginKey, String server, int port, String contextPath, String username, String password, File pluginFile, String signature) {
        this.pluginKey = pluginKey;
        this.serverUrl = BaseUrlUtils.getBaseUrl(server, port, contextPath);
        this.username = username;
        this.password = password;
        this.pluginFile = pluginFile;
        this.signature = signature;
    }

    public String getPluginKey() {
        return this.pluginKey;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getUpmUrl() {
        return this.serverUrl + UPM_ROOT_RESOURCE;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public File getPluginFile() {
        return this.pluginFile;
    }

    public String getSignature() {
        return this.signature;
    }

    public static class Builder {
        private String pluginKey;
        private String server;
        private int port;
        private String contextPath;
        private String username;
        private String password;
        private File pluginFile;
        private String signature;

        public Builder pluginKey(String pluginKey) {
            this.pluginKey = pluginKey;
            return this;
        }

        public Builder server(String server) {
            this.server = server;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder contextPath(String contextPath) {
            this.contextPath = contextPath;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder pluginFile(File file) {
            this.pluginFile = file;
            return this;
        }

        public Builder signature(String signature) {
            this.signature = signature;
            return this;
        }

        public InstallParams build() {
            return new InstallParams(this.pluginKey, this.server, this.port, this.contextPath, this.username, this.password, this.pluginFile, this.signature);
        }
    }
}

