/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import com.atlassian.maven.plugins.amps.util.ProductHandlerUtil;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class Node {
    private static final String DEBUG_ARGS_FORMAT = " -Xdebug -Xrunjdwp:transport=dt_socket,address=%d,suspend=%s,server=y ";
    private final Map<String, String> systemProperties = new HashMap<String, String>();
    private Boolean jvmDebugSuspend;
    private boolean useHttps;
    private int ajpPort;
    private int httpPort;
    private int httpsPort;
    private int jvmDebugPort;
    private int rmiPort;
    private String debugArgs;

    public Node() {
    }

    public Node(boolean useHttps, int ajpPort, int jvmDebugPort, int httpPort, int httpsPort, int rmiPort, String debugArgs) {
        this.useHttps = useHttps;
        this.ajpPort = ajpPort;
        this.debugArgs = debugArgs;
        this.jvmDebugPort = jvmDebugPort;
        this.httpPort = httpPort;
        this.httpsPort = httpsPort;
        this.rmiPort = rmiPort;
    }

    public int getAjpPort() {
        return this.ajpPort;
    }

    public void setAjpPort(int ajpPort) {
        this.ajpPort = ajpPort;
    }

    @Nonnull
    public String getDebugArgs() {
        return StringUtils.defaultString((String)this.debugArgs);
    }

    public void setDebugArgs(String debugArgs) {
        this.debugArgs = debugArgs;
    }

    public int getJvmDebugPort() {
        return this.jvmDebugPort;
    }

    public void setJvmDebugPort(int jvmDebugPort) {
        this.jvmDebugPort = jvmDebugPort;
    }

    public int getRmiPort() {
        return this.rmiPort;
    }

    public void setRmiPort(int rmiPort) {
        this.rmiPort = rmiPort;
    }

    @Nonnull
    public Map<String, String> getSystemProperties() {
        return Collections.unmodifiableMap(this.systemProperties);
    }

    public int getWebPort() {
        return this.useHttps ? this.httpsPort : this.httpPort;
    }

    public void setWebPort(int webPort) {
        if (this.useHttps) {
            this.httpsPort = webPort;
        } else {
            this.httpPort = webPort;
        }
    }

    @VisibleForTesting
    void setJvmDebugSuspend(boolean jvmDebugSuspend) {
        this.jvmDebugSuspend = jvmDebugSuspend;
    }

    public void defaultDebugArgs(boolean jvmDebugSuspend) {
        if (StringUtils.isNotBlank((CharSequence)this.debugArgs)) {
            return;
        }
        if (this.jvmDebugPort == 0) {
            throw new IllegalStateException("Cannot set debug args unless debug port is set");
        }
        boolean suspend = Optional.ofNullable(this.jvmDebugSuspend).orElse(jvmDebugSuspend);
        String suspendArg = suspend ? "y" : "n";
        this.setDebugArgs(String.format(DEBUG_ARGS_FORMAT, this.jvmDebugPort, suspendArg));
    }

    public void ensureNonDebugPortsAreSet(String instanceId) {
        if (this.ajpPort == 0) {
            this.setAjpPort(this.resolvePort(this.getAjpPort(), instanceId, "AJP"));
        }
        if (this.rmiPort == 0) {
            this.setRmiPort(this.resolvePort(this.getRmiPort(), instanceId, "RMI"));
        }
        if (this.getWebPort() == 0) {
            this.setWebPort(this.resolvePort(this.getWebPort(), instanceId, "HTTP(S)"));
        }
    }

    private int resolvePort(int configuredPort, String instanceId, String purpose) {
        if (configuredPort == 0) {
            return ProductHandlerUtil.pickFreePort(0);
        }
        if (ProductHandlerUtil.isPortFree(configuredPort)) {
            return configuredPort;
        }
        throw new IllegalArgumentException(String.format("%s: The configured %s port, %d, is in use", instanceId, purpose, configuredPort));
    }

    public void defaultSystemProperty(String key, Supplier<String> valueSupplier) {
        this.systemProperties.computeIfAbsent(key, k -> (String)valueSupplier.get());
    }

    public void setSystemProperty(String key, String value) {
        this.systemProperties.put(key, value);
    }
}

