/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import com.atlassian.maven.plugins.amps.AbstractProductHandlerMojo;
import com.atlassian.maven.plugins.amps.InstallParams;
import com.atlassian.maven.plugins.amps.MavenContext;
import com.atlassian.maven.plugins.amps.MavenGoals;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.util.ClassUtils;
import com.atlassian.maven.plugins.amps.util.WiredTestInfo;
import com.atlassian.upm.signing.tool.SignatureBuilder;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.model.Build;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="remote-test", requiresDependencyResolution=ResolutionScope.TEST, defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST)
@Execute(phase=LifecyclePhase.PACKAGE)
public class RemoteTestMojo
extends AbstractProductHandlerMojo {
    @Component
    private ArtifactHandlerManager artifactHandlerManager;
    @Parameter
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    @Parameter(property="functional.test.pattern")
    private String functionalTestPattern = "it/**";
    @Parameter(property="project.build.testOutputDirectory", required=true)
    private File testClassesDirectory;
    @Parameter(property="maven.test.skip", defaultValue="false")
    private boolean testsSkip;
    @Parameter(property="skipTests", defaultValue="false")
    private boolean skipTests;
    @Parameter(property="skipITs", defaultValue="false")
    private boolean skipITs;
    @Parameter(property="http.port", defaultValue="80")
    protected int httpPort;
    @Parameter(property="pdk.username", defaultValue="admin")
    protected String pdkUsername;
    @Parameter(property="pdk.password", defaultValue="admin")
    protected String pdkPassword;
    @Parameter(property="privateKey")
    private String privateKey;
    @Parameter(property="privateKeyFile")
    private String privateKeyFile;
    @Parameter
    protected List<ProductArtifact> deployArtifacts = new ArrayList<ProductArtifact>();
    @Parameter
    protected String category;

    @Override
    protected void doExecute() throws MojoExecutionException {
        if (StringUtils.isBlank((CharSequence)this.server)) {
            this.getLog().error((CharSequence)"server is not set!");
            return;
        }
        if (this.contextPath == null || StringUtils.trim((String)this.contextPath).equals("/")) {
            this.contextPath = "";
        }
        if (this.httpPort < 1) {
            this.httpPort = 80;
        }
        if (!this.shouldBuildTestPlugin()) {
            this.getLog().info((CharSequence)"shouldBuildTestPlugin is false... skipping test run!");
            return;
        }
        MavenProject project = this.getMavenContext().getProject();
        project.getArtifact().setArtifactHandler(this.artifactHandlerManager.getArtifactHandler("jar"));
        if (!new File(this.testClassesDirectory, "it").exists()) {
            this.getLog().info((CharSequence)"No integration tests found");
            return;
        }
        if (this.skipTests || this.testsSkip || this.skipITs) {
            this.getLog().info((CharSequence)"Integration tests skipped");
            return;
        }
        MavenGoals goals = this.getMavenGoals();
        String pluginJar = this.targetDirectory.getAbsolutePath() + "/" + this.finalName + ".jar";
        Optional<SignatureBuilder> signatureBuilder = this.getPropertyValue(this.privateKey, "privateKey", this.privateKeyFile, "privateKeyFile").map(SignatureBuilder::withPrivateKey);
        this.runTests(goals, pluginJar, signatureBuilder, this.copy(this.systemPropertyVariables));
    }

    private Map<String, Object> copy(Map<String, Object> systemPropertyVariables) {
        return new HashMap<String, Object>(systemPropertyVariables);
    }

    private String getBaseUrl(String server, int actualHttpPort, String contextPath) {
        String port = actualHttpPort != 80 ? ":" + actualHttpPort : "";
        String string = server = server.startsWith("http") ? server : "http://" + server;
        if (!contextPath.startsWith("/") && StringUtils.isNotBlank((CharSequence)contextPath)) {
            contextPath = "/" + contextPath;
        }
        return server + port + contextPath;
    }

    private void runTests(MavenGoals goals, String pluginJar, Optional<SignatureBuilder> signatureBuilder, Map<String, Object> systemProperties) throws MojoExecutionException {
        try {
            MavenContext ctx = this.getMavenContext();
            Build build = ctx.getProject().getBuild();
            File buildDir = new File(build.getDirectory());
            File testClassesDir = new File(build.getTestOutputDirectory());
            List<String> wiredTestClasses = this.getWiredTestClassnames(testClassesDir);
            if (wiredTestClasses.isEmpty()) {
                this.getLog().info((CharSequence)"No wired integration tests found, skipping remote testing...");
                return;
            }
            ArrayList<String> includes = new ArrayList<String>(wiredTestClasses.size());
            for (String wiredClass : wiredTestClasses) {
                String includePath = wiredClass.replaceAll("\\.", "/");
                includes.add(includePath + "*");
            }
            List<String> excludes = Collections.emptyList();
            systemProperties.put("http.port", this.httpPort);
            systemProperties.put("context.path", this.contextPath);
            systemProperties.put("plugin.jar", pluginJar);
            if (!systemProperties.containsKey("baseurl")) {
                systemProperties.put("baseurl", this.getBaseUrl(this.server, this.httpPort, this.contextPath));
            }
            Map<ProductArtifact, File> frameworkFiles = this.getFrameworkFiles();
            File junitFile = null;
            for (Map.Entry<ProductArtifact, File> entry : frameworkFiles.entrySet()) {
                ProductArtifact artifact = entry.getKey();
                File file = entry.getValue();
                if (!file.getName().startsWith("org.apache.servicemix.bundles.junit")) continue;
                junitFile = file;
                frameworkFiles.remove(artifact);
                break;
            }
            File mainPlugin = new File(buildDir, this.finalName + ".jar");
            File testPlugin = new File(buildDir, this.finalName + "-tests.jar");
            if (junitFile == null || !junitFile.exists()) {
                throw new MojoExecutionException("couldn't find junit!!!!");
            }
            this.installPluginFileIfNotInstalled(junitFile, signatureBuilder);
            for (Map.Entry entry : frameworkFiles.entrySet()) {
                this.installPluginFileIfNotInstalled((File)entry.getValue(), signatureBuilder);
            }
            this.installPluginFile(mainPlugin, signatureBuilder);
            this.installPluginFile(testPlugin, signatureBuilder);
            String reportsDirectory = MavenGoals.getReportsDirectory(this.targetDirectory);
            goals.runIntegrationTests(reportsDirectory, includes, excludes, systemProperties, this.category, null, null);
            goals.runVerify(reportsDirectory);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error running remote tests...", e);
        }
    }

    private void installPluginFileIfNotInstalled(File pluginFile, Optional<SignatureBuilder> signatureBuilder) throws IOException, MojoExecutionException {
        this.getLog().info((CharSequence)("checking to see if we need to install " + pluginFile.getName()));
        Manifest manifest = RemoteTestMojo.getManifest(pluginFile);
        String pluginKey = null;
        String pluginVersion = null;
        if (manifest == null) {
            this.getLog().info((CharSequence)"no manifest found for plugin!");
        } else {
            pluginKey = manifest.getMainAttributes().getValue("Bundle-SymbolicName");
            pluginVersion = manifest.getMainAttributes().getValue("Bundle-Version");
            this.getLog().info((CharSequence)("pluginKey from manifest is: " + pluginKey));
        }
        if (StringUtils.isBlank((CharSequence)pluginKey)) {
            this.getLog().info((CharSequence)"no plugin key found, installing without check...");
            this.installPluginFile(pluginFile, signatureBuilder);
        } else {
            boolean foundPlugin = false;
            if (this.pluginExists(pluginKey + "-key")) {
                this.getLog().info((CharSequence)"found the plugin!");
                foundPlugin = true;
            } else {
                this.getLog().info((CharSequence)"not found, trying again with version tacked on ...");
                if (this.pluginExists(pluginKey + "-" + pluginVersion + "-key")) {
                    this.getLog().info((CharSequence)"found the plugin!");
                    foundPlugin = true;
                }
            }
            if (foundPlugin) {
                this.getLog().debug((CharSequence)"found the plugin ...");
            } else {
                this.getLog().info((CharSequence)"didn't find the plugin, so I'm installing it ...");
                this.installPluginFile(pluginFile, signatureBuilder);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private boolean pluginExists(String pluginPath) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Manifest getManifest(File jarFile) throws IOException {
        try (JarFile jar = new JarFile(jarFile);){
            Manifest manifest = jar.getManifest();
            return manifest;
        }
    }

    private void installPluginFile(File pluginFile, Optional<SignatureBuilder> signatureBuilderOptional) throws MojoExecutionException {
        this.getLog().info((CharSequence)"trying to install plugin with the following properties:");
        this.getLog().info((CharSequence)("pluginFile: " + pluginFile.getAbsolutePath()));
        this.getLog().info((CharSequence)("pluginKey: " + pluginFile.getName()));
        this.getLog().info((CharSequence)("Signature: " + signatureBuilderOptional.isPresent()));
        this.getLog().info((CharSequence)("server: " + this.server));
        this.getLog().info((CharSequence)("httpPort: " + this.httpPort));
        this.getLog().info((CharSequence)("contextPath: " + this.contextPath));
        this.getLog().info((CharSequence)("username: " + this.pdkUsername));
        InstallParams params = new InstallParams.Builder().pluginFile(pluginFile).pluginKey(pluginFile.getName()).server(this.server).port(this.httpPort).contextPath(this.contextPath).username(this.pdkUsername).password(this.pdkPassword).signature(signatureBuilderOptional.map(sb -> sb.forgeSignature(pluginFile)).orElse(null)).build();
        this.getPluginInstaller().installPlugin(params);
    }

    private List<String> getWiredTestClassnames(File testClassesDir) {
        MavenProject prj = this.getMavenContext().getProject();
        ArrayList<String> wiredClasses = new ArrayList<String>();
        if (testClassesDir.exists()) {
            Collection classFiles = FileUtils.listFiles((File)testClassesDir, (String[])new String[]{"class"}, (boolean)true);
            for (File classFile : classFiles) {
                String className = ClassUtils.getClassnameFromFile(classFile, prj.getBuild().getTestOutputDirectory());
                WiredTestInfo wiredInfo = ClassUtils.getWiredTestInfo(classFile);
                if (!wiredInfo.isWiredTest()) continue;
                wiredClasses.add(className);
            }
        }
        return wiredClasses;
    }

    private Map<ProductArtifact, File> getFrameworkFiles() throws MojoExecutionException {
        ArrayList<ProductArtifact> pluginsToDeploy = new ArrayList<ProductArtifact>(this.getTestFrameworkPlugins());
        pluginsToDeploy.addAll(this.deployArtifacts);
        HashMap<ProductArtifact, File> artifactFileMap = new HashMap<ProductArtifact, File>(pluginsToDeploy.size());
        try {
            File tmpDir = new File(this.getMavenContext().getProject().getBuild().getDirectory(), "tmp-artifacts");
            FileUtils.forceMkdir((File)tmpDir);
            FileUtils.cleanDirectory((File)tmpDir);
            this.getMavenGoals().copyPlugins(tmpDir, pluginsToDeploy);
            for (File artifactFile : FileUtils.listFiles((File)tmpDir, null, (boolean)false)) {
                pluginsToDeploy.stream().filter(productArtifact -> artifactFile.getName().startsWith(productArtifact.getArtifactId())).findFirst().ifPresent(productArtifact -> artifactFileMap.put((ProductArtifact)productArtifact, artifactFile));
            }
            return artifactFileMap;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error copying framework files", e);
        }
    }
}

