/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.database;

import com.atlassian.maven.plugins.amps.DataSource;
import com.atlassian.maven.plugins.amps.database.DatabaseType;
import com.atlassian.maven.plugins.amps.database.H2;
import com.atlassian.maven.plugins.amps.database.Hsql;
import com.atlassian.maven.plugins.amps.database.MssqlJtds;
import com.atlassian.maven.plugins.amps.database.MssqlMicrosoft;
import com.atlassian.maven.plugins.amps.database.MySQL;
import com.atlassian.maven.plugins.amps.database.Oracle10g;
import com.atlassian.maven.plugins.amps.database.Oracle12c;
import com.atlassian.maven.plugins.amps.database.Postgres;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.maven.plugin.logging.Log;

public class DatabaseTypeFactory {
    private final Collection<DatabaseType> supportedDatabaseTypes;

    public DatabaseTypeFactory(@Nonnull Log log) {
        this.supportedDatabaseTypes = Arrays.asList(new Hsql(), new H2(), new MySQL(log), new Postgres(log), new MssqlJtds(log), new MssqlMicrosoft(log), new Oracle12c(log), new Oracle10g(log));
    }

    @Nonnull
    public Optional<DatabaseType> getDatabaseType(DataSource dataSource) {
        return this.supportedDatabaseTypes.stream().filter(db -> db.isTypeOf(dataSource)).findFirst();
    }
}

