/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.database;

import com.atlassian.maven.plugins.amps.DataSource;
import com.atlassian.maven.plugins.amps.database.AbstractOracleDatabase;
import com.atlassian.maven.plugins.amps.database.Oracle10g;
import com.atlassian.maven.plugins.amps.util.FileUtils;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.sql.DatabaseMetaData;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.maven.plugin.logging.Log;
import org.springframework.jdbc.core.JdbcTemplate;

@ParametersAreNonnullByDefault
public class Oracle12c
extends AbstractOracleDatabase {
    public static final String ORACLE_12C_VERSION_PREFIX = "Oracle Database 12c";

    public Oracle12c(Log log) {
        super(log, "oracle12c");
    }

    @Override
    protected String getSqlToDropAndCreateUser(DataSource dataSource) {
        if (this.oracleInStandaloneMode(dataSource)) {
            return new Oracle10g(this.log).getSqlToDropAndCreateUser(dataSource);
        }
        return this.getTenantedModeDropAndCreateUserQuery(dataSource);
    }

    private String getTenantedModeDropAndCreateUserQuery(DataSource dataSource) {
        String dumpFileDirectoryPath = new File(dataSource.getDumpFilePath()).getParent();
        return FileUtils.readFileToString("oracle12c-template.sql", this.getClass(), StandardCharsets.UTF_8).replace("v_data_pump_dir", dumpFileDirectoryPath).replace("v_product_user", dataSource.getUsername()).replace("v_product_pwd", dataSource.getPassword());
    }

    private boolean oracleInStandaloneMode(DataSource dataSource) {
        JdbcTemplate jdbcOperations = new JdbcTemplate(dataSource.getJdbcDataSource());
        String isCdb = (String)jdbcOperations.queryForObject("select cdb from v$database", String.class);
        return isCdb == null || isCdb.toLowerCase().startsWith("n");
    }

    @Override
    public boolean isTypeOf(DataSource dataSource) {
        return super.isTypeOf(dataSource) && Oracle12c.dbProductVersionIsOracle12c(dataSource);
    }

    private static boolean dbProductVersionIsOracle12c(DataSource dataSource) {
        return dataSource.getJdbcMetaData(DatabaseMetaData::getDatabaseProductVersion).filter(version -> version.startsWith(ORACLE_12C_VERSION_PREFIX)).isPresent();
    }
}

