/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.frontend.association.mapping;

import com.atlassian.maven.plugins.amps.frontend.association.mapping.model.ExternalFeManifestAssociationConfiguration;
import com.atlassian.maven.plugins.amps.frontend.association.mapping.model.FeDependencyDeclaration;
import com.atlassian.maven.plugins.amps.frontend.association.mapping.model.FeDependencyDeclarationParameter;
import com.atlassian.maven.plugins.amps.frontend.association.mapping.model.FeManifestAssociation;
import com.atlassian.maven.plugins.amps.frontend.association.mapping.model.FeManifestAssociationParameter;
import com.atlassian.maven.plugins.amps.frontend.association.mapping.model.WebResourcePluginFeManifestAssociationConfiguration;
import com.atlassian.maven.plugins.amps.frontend.association.mapping.utils.DirectoryHelper;
import com.atlassian.maven.plugins.amps.frontend.association.mapping.utils.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.maven.plugin.MojoExecutionException;

public class FeDeclarationReader {
    private static final String WEB_RESOURCE_PLUGIN_CONFIGURATIONS_SUFFIX = ".intermediary.json";
    private final DirectoryHelper directoryHelper;
    private final JsonParser jsonParser;

    public FeDeclarationReader(DirectoryHelper directoryHelper, JsonParser jsonParser) {
        this.directoryHelper = directoryHelper;
        this.jsonParser = jsonParser;
    }

    public List<FeManifestAssociation> getManifestAssociations(List<FeManifestAssociationParameter> manifestAssociationConfigurations) throws MojoExecutionException {
        List<FeManifestAssociation> fromConfiguration = this.getManifestAssociationsFromConfiguration(manifestAssociationConfigurations);
        List<FeManifestAssociation> fromWebResourcePlugin = this.getManifestAssociationsFromWebResourcePluginConfigurations(this.directoryHelper.getOutputFileAbsolutePath("META-INF/fe-manifest-associations"));
        return Stream.of(fromConfiguration.stream(), fromWebResourcePlugin.stream()).flatMap(i -> i).collect(Collectors.toList());
    }

    public List<FeDependencyDeclaration> getDependencyDeclarations(List<FeDependencyDeclarationParameter> dependencyDeclarationConfigurations) throws MojoExecutionException {
        ArrayList<FeDependencyDeclaration> dependencyDeclarations = new ArrayList<FeDependencyDeclaration>();
        HashSet<String> externalConfigurations = new HashSet<String>();
        if (dependencyDeclarationConfigurations != null) {
            for (FeDependencyDeclarationParameter dependencyDeclarationConfiguration : dependencyDeclarationConfigurations) {
                if (dependencyDeclarationConfiguration.getNonAtlassianArtifactDeclaration() != null) {
                    externalConfigurations.add(dependencyDeclarationConfiguration.getNonAtlassianArtifactDeclaration());
                    continue;
                }
                dependencyDeclarations.add(this.createDependencyDeclarationFromConfiguration(dependencyDeclarationConfiguration));
            }
        }
        for (String externalConfiguration : externalConfigurations) {
            List<FeDependencyDeclarationParameter> jsonDeclarations = this.getDependencyDeclarationFromJsonConfiguration(externalConfiguration);
            dependencyDeclarations.addAll(jsonDeclarations.stream().map(this::createDependencyDeclarationFromConfiguration).collect(Collectors.toList()));
        }
        return dependencyDeclarations;
    }

    @Nonnull
    @VisibleForTesting
    protected List<FeManifestAssociation> getManifestAssociationsFromWebResourcePluginConfigurations(String webResourcePluginConfigurationsPath) throws MojoExecutionException {
        File[] directoryFiles;
        File webResourcePluginDirectory = new File(webResourcePluginConfigurationsPath);
        ArrayList<FeManifestAssociation> manifestAssociations = new ArrayList<FeManifestAssociation>();
        if (webResourcePluginDirectory.exists() && webResourcePluginDirectory.isDirectory() && (directoryFiles = webResourcePluginDirectory.listFiles()) != null) {
            for (File fileEntry : directoryFiles) {
                if (fileEntry.isDirectory() || !fileEntry.getName().endsWith(WEB_RESOURCE_PLUGIN_CONFIGURATIONS_SUFFIX)) continue;
                manifestAssociations.add(this.getManifestAssociationFromWebResourcePluginConfiguration(fileEntry.getAbsolutePath()));
            }
        }
        return manifestAssociations;
    }

    private FeManifestAssociation getManifestAssociationFromWebResourcePluginConfiguration(String webResourcePluginConfigurationAbsPath) throws MojoExecutionException {
        WebResourcePluginFeManifestAssociationConfiguration webResourcePluginConfiguration;
        File webResourcePluginConfigurationFile = new File(webResourcePluginConfigurationAbsPath);
        try {
            webResourcePluginConfiguration = this.jsonParser.readFile(webResourcePluginConfigurationFile, WebResourcePluginFeManifestAssociationConfiguration.class);
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("Intermediary manifest association from web resource build plugin couldn't be parsed. Path: %s", webResourcePluginConfigurationAbsPath));
        }
        return new FeManifestAssociation(webResourcePluginConfiguration.getPackageName(), webResourcePluginConfiguration.getOutputDirectoryFiles(), this.directoryHelper.getPathRelativeToSourceDirectory(webResourcePluginConfigurationFile.getAbsolutePath()));
    }

    @Nonnull
    @VisibleForTesting
    protected FeManifestAssociation getManifestAssociationsFromJsonConfiguration(String externalConfigurationPath) throws MojoExecutionException {
        ExternalFeManifestAssociationConfiguration externalConfiguration;
        String externalConfigurationAbsolutePath = this.directoryHelper.getSourceFileAbsolutePath(externalConfigurationPath);
        File externalConfigurationFile = new File(externalConfigurationAbsolutePath);
        try {
            externalConfiguration = this.jsonParser.readFile(externalConfigurationFile, ExternalFeManifestAssociationConfiguration.class);
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("External manifest association couldn't be parsed. Path: %s", externalConfigurationAbsolutePath));
        }
        return new FeManifestAssociation(externalConfiguration.getPackageName(), externalConfiguration.getManuallyVerifiedEveryFileHasItsDependenciesDeclaredInTheManifest().getOutputDirectoryFiles(), this.directoryHelper.getPathRelativeToSourceDirectory(externalConfigurationPath));
    }

    @Nonnull
    @VisibleForTesting
    protected List<FeDependencyDeclarationParameter> getDependencyDeclarationFromJsonConfiguration(String externalConfigurationPath) throws MojoExecutionException {
        String externalConfigurationAbsolutePath = this.directoryHelper.getSourceFileAbsolutePath(externalConfigurationPath);
        File externalConfigurationFile = new File(externalConfigurationAbsolutePath);
        try {
            return this.jsonParser.readFile(externalConfigurationFile, new TypeReference<List<FeDependencyDeclarationParameter>>(){});
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("External dependency declaration in json format couldn't be parsed. Path: %s", externalConfigurationAbsolutePath));
        }
    }

    @Nonnull
    private List<FeManifestAssociation> getManifestAssociationsFromConfiguration(List<FeManifestAssociationParameter> manifestAssociationConfigurations) throws MojoExecutionException {
        ArrayList<FeManifestAssociation> manifestAssociations = new ArrayList<FeManifestAssociation>();
        HashSet<String> externalConfigurations = new HashSet<String>();
        if (manifestAssociationConfigurations != null) {
            for (FeManifestAssociationParameter associationConfiguration : manifestAssociationConfigurations) {
                if (associationConfiguration.getOutputDirectoryFilesDeclaration() != null) {
                    externalConfigurations.add(associationConfiguration.getOutputDirectoryFilesDeclaration());
                    continue;
                }
                manifestAssociations.add(this.createManifestAssociationFromConfiguration(associationConfiguration));
            }
        }
        for (String externalConfiguration : externalConfigurations) {
            FeManifestAssociation manifestAssociation = this.getManifestAssociationsFromJsonConfiguration(externalConfiguration);
            manifestAssociations.add(manifestAssociation);
        }
        return manifestAssociations;
    }

    private FeManifestAssociation createManifestAssociationFromConfiguration(FeManifestAssociationParameter associationConfiguration) {
        return new FeManifestAssociation(associationConfiguration.getPackageName(), associationConfiguration.getFilesDeclaration().getOutputDirectoryFiles().stream().filter(path -> path != null && !path.isEmpty()).map(String::trim).collect(Collectors.toList()), "pom.xml");
    }

    private FeDependencyDeclaration createDependencyDeclarationFromConfiguration(FeDependencyDeclarationParameter dependencyDeclarationConfiguration) {
        return new FeDependencyDeclaration(dependencyDeclarationConfiguration.getManuallyVerifiedNonAtlassianArtifactPath(), dependencyDeclarationConfiguration.getManuallyVerifiedEveryJsDoesntHaveExternalDependencies().stream().filter(path -> path != null && !path.isEmpty()).map(String::trim).collect(Collectors.toList()));
    }
}

