/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.minifier;

import com.atlassian.maven.plugins.amps.code.Sources;
import com.atlassian.maven.plugins.amps.minifier.Minifier;
import com.atlassian.maven.plugins.amps.minifier.MinifierParameters;
import com.atlassian.maven.plugins.amps.minifier.strategies.NoMinificationStrategy;
import com.atlassian.maven.plugins.amps.minifier.strategies.XmlMinifierStrategy;
import com.atlassian.maven.plugins.amps.minifier.strategies.googleclosure.GoogleClosureJsMinifierStrategy;
import com.atlassian.maven.plugins.amps.minifier.strategies.yui.YUICompressorCssMinifierStrategy;
import com.atlassian.maven.plugins.amps.minifier.strategies.yui.YUICompressorJsMinifierStrategy;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.DirectoryScanner;

public class ResourcesMinifier {
    private static final List<String> MINIFIED_FILENAME_SUFFIXES = Arrays.asList("-min", ".min");
    private final MinifierParameters minifierParameters;

    public ResourcesMinifier(MinifierParameters minifierParameters) {
        this.minifierParameters = Objects.requireNonNull(minifierParameters);
    }

    public void minify(List<Resource> resources, String outputPath) throws MojoExecutionException {
        for (Resource resource : resources) {
            this.minify(resource, outputPath);
        }
    }

    public void minify(Resource resource, String outputPath) throws MojoExecutionException {
        File resourceDir = new File(resource.getDirectory());
        if (!resourceDir.exists()) {
            return;
        }
        File outputDir = new File(outputPath);
        String targetPath = resource.getTargetPath();
        File destDir = StringUtils.isNotBlank((CharSequence)targetPath) ? new File(outputDir, targetPath) : outputDir;
        for (String type : this.getFiletypesToProcess()) {
            this.processFiletypeInDirectory(type, resourceDir, destDir, resource.getIncludes(), resource.getExcludes());
        }
    }

    public void processFiletypeInDirectory(@Nonnull String filetype, File resourceDir, File destDir, List<String> includes, List<String> excludes) throws MojoExecutionException {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(resourceDir);
        if (CollectionUtils.isNotEmpty(includes)) {
            scanner.setIncludes(includes.toArray(new String[0]));
        } else {
            scanner.setIncludes(Collections.singletonList("**/*." + filetype).toArray(new String[0]));
        }
        if (CollectionUtils.isNotEmpty(excludes)) {
            scanner.setExcludes(excludes.toArray(new String[0]));
        }
        scanner.addDefaultExcludes();
        scanner.scan();
        this.processFileList(filetype, destDir, Arrays.stream(scanner.getIncludedFiles()).filter(s -> FilenameUtils.getExtension((String)s).endsWith(filetype)).collect(Collectors.toMap(s -> s, s -> new File(resourceDir, (String)s))));
    }

    private void processFileList(@Nonnull String extname, File destDir, Map<String, File> filenames) throws MojoExecutionException {
        Log log = this.minifierParameters.getLog();
        Minifier strategy = this.getMinifierStrategy(extname);
        int minified = 0;
        int copied = 0;
        for (Map.Entry<String, File> entry : filenames.entrySet()) {
            String path = entry.getKey();
            File sourceFile = entry.getValue();
            try {
                if (!sourceFile.canRead()) continue;
                if (this.maybeCopyPreminifiedFileToDest(sourceFile, destDir)) {
                    ++copied;
                    continue;
                }
                String destFilename = "xml".equals(extname) ? path : ResourcesMinifier.getMinifiedFilepath(path);
                File destFile = new File(destDir, destFilename);
                if (destFile.exists() && destFile.lastModified() > sourceFile.lastModified()) {
                    log.debug((CharSequence)("Nothing to do, " + destFile.getAbsolutePath() + " is younger than the original"));
                    continue;
                }
                log.debug((CharSequence)("minifying to " + destFile.getAbsolutePath()));
                Charset cs = this.minifierParameters.getCs();
                Sources input = new Sources(FileUtils.readFileToString((File)sourceFile, (Charset)cs));
                Sources output = this.processSources(input, strategy, destFile.getAbsolutePath());
                FileUtils.forceMkdir((File)destFile.getParentFile());
                FileUtils.writeStringToFile((File)destFile, (String)output.getContent(), (Charset)cs);
                if (output.hasSourceMap()) {
                    File sourceMapFile = new File(destFile.getAbsolutePath() + ".map");
                    FileUtils.writeStringToFile((File)sourceMapFile, (String)output.getSourceMapContent(), (Charset)cs);
                }
                ++minified;
            }
            catch (IOException e) {
                throw new MojoExecutionException("IOException when minifying '" + path + "'", (Exception)e);
            }
        }
        log.info((CharSequence)String.format("%d %s file(s) were output to target directory %s", minified + copied, extname, destDir.getAbsolutePath()));
    }

    private boolean maybeCopyPreminifiedFileToDest(File sourceFile, File destDir) throws IOException {
        Log log = this.minifierParameters.getLog();
        String path = sourceFile.getName();
        String pathNoExt = FilenameUtils.removeExtension((String)path);
        for (String s : MINIFIED_FILENAME_SUFFIXES) {
            if (!pathNoExt.endsWith(s)) continue;
            String pathNoSuffix = pathNoExt.substring(0, pathNoExt.length() - s.length()) + "." + FilenameUtils.getExtension((String)path);
            File destFile = new File(destDir, ResourcesMinifier.getMinifiedFilepath(pathNoSuffix));
            log.debug((CharSequence)String.format("Copying pre-minified file '%s' to destination '%s' file ends in '%s'", path, destFile.getName(), s));
            FileUtils.copyFile((File)sourceFile, (File)destFile);
            return true;
        }
        return false;
    }

    private Sources processSources(Sources input, Minifier strategy, String filenameForLogging) throws IOException {
        return input.getContent().isEmpty() ? input : strategy.minify(input, this.minifierParameters, filenameForLogging);
    }

    private List<String> getFiletypesToProcess() {
        ArrayList<String> types = new ArrayList<String>();
        if (this.minifierParameters.isCompressJs()) {
            types.add("js");
        }
        if (this.minifierParameters.isCompressCss()) {
            types.add("css");
        }
        types.add("xml");
        return types;
    }

    private Minifier getMinifierStrategy(String extname) {
        boolean withClosure = this.minifierParameters.isUseClosureForJs();
        switch (extname) {
            case "js": {
                return withClosure ? new GoogleClosureJsMinifierStrategy() : new YUICompressorJsMinifierStrategy();
            }
            case "css": {
                return new YUICompressorCssMinifierStrategy();
            }
            case "xml": {
                return new XmlMinifierStrategy();
            }
        }
        return new NoMinificationStrategy();
    }

    private static String getMinifiedFilepath(String path) {
        String filepathSansExtension = FilenameUtils.removeExtension((String)path);
        String minifiedExtension = "-min." + FilenameUtils.getExtension((String)path);
        return filepathSansExtension + minifiedExtension;
    }
}

