/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.osgi;

import com.atlassian.maven.plugins.amps.AbstractAmpsMojo;
import com.atlassian.maven.plugins.amps.util.FileUtils;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate-test-manifest")
public class GenerateTestManifestMojo
extends AbstractAmpsMojo {
    private static final String BUILD_DATE_ATTRIBUTE = "Atlassian-Build-Date";
    private final DateFormat buildDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    @Parameter
    private Map<String, String> testInstructions = new HashMap<String, String>();
    @Parameter(property="project.build.finalName")
    private String finalName;
    @Parameter(defaultValue="false")
    private boolean legacyOutputDirectoryForTestManifest;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.shouldBuildTestPlugin()) {
            MavenProject project = this.getMavenContext().getProject();
            String buildDateStr = this.buildDateFormat.format(new Date());
            ImmutableMap basicAttributes = ImmutableMap.of((Object)BUILD_DATE_ATTRIBUTE, (Object)buildDateStr);
            if (!this.testInstructions.isEmpty()) {
                File metaInfLib;
                this.getLog().info((CharSequence)"Generating a manifest for this test plugin");
                if (!this.testInstructions.containsKey("Bundle-SymbolicName")) {
                    this.testInstructions.put("Bundle-SymbolicName", this.finalName + "-tests");
                } else if (!this.testInstructions.get("Bundle-SymbolicName").endsWith("-tests")) {
                    this.testInstructions.put("Bundle-SymbolicName", this.testInstructions.get("Bundle-SymbolicName") + "-tests");
                }
                if (!this.testInstructions.containsKey("Bundle-Name")) {
                    this.testInstructions.put("Bundle-Name", this.getMavenContext().getProject().getName() + " Tests");
                }
                if (!this.testInstructions.containsKey("Export-Package")) {
                    this.testInstructions.put("Export-Package", "");
                }
                if ((metaInfLib = FileUtils.file(project.getBuild().getTestOutputDirectory(), "META-INF", "lib")).isDirectory()) {
                    StringBuilder classpath = new StringBuilder(".");
                    File[] metaInfFiles = metaInfLib.listFiles();
                    if (metaInfFiles != null) {
                        for (File lib : metaInfFiles) {
                            classpath.append(",META-INF/lib/").append(lib.getName());
                        }
                    }
                    this.testInstructions.put("Bundle-ClassPath", classpath.toString());
                }
                this.getMavenGoals().generateTestBundleManifest(this.testInstructions, (Map<String, String>)basicAttributes, this.legacyOutputDirectoryForTestManifest);
            } else {
                this.getMavenGoals().generateTestMinimalManifest((Map<String, String>)basicAttributes);
            }
        }
    }
}

