/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product;

import com.atlassian.maven.plugins.amps.MavenContext;
import com.atlassian.maven.plugins.amps.MavenGoals;
import com.atlassian.maven.plugins.amps.product.BambooProductHandler;
import com.atlassian.maven.plugins.amps.product.BitbucketProductHandler;
import com.atlassian.maven.plugins.amps.product.ConfluenceProductHandler;
import com.atlassian.maven.plugins.amps.product.CrowdProductHandler;
import com.atlassian.maven.plugins.amps.product.CtkServerProductHandler;
import com.atlassian.maven.plugins.amps.product.FeCruProductHandler;
import com.atlassian.maven.plugins.amps.product.JiraProductHandler;
import com.atlassian.maven.plugins.amps.product.ProductHandler;
import com.atlassian.maven.plugins.amps.product.RefappProductHandler;
import com.atlassian.maven.plugins.amps.product.manager.WebAppManager;
import com.atlassian.maven.plugins.amps.util.MavenProjectLoader;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.repository.RepositorySystem;

public final class ProductHandlerFactory {
    public static final String REFAPP = "refapp";
    public static final String CONFLUENCE = "confluence";
    public static final String JIRA = "jira";
    public static final String BAMBOO = "bamboo";
    public static final String BITBUCKET = "bitbucket";
    public static final String FECRU = "fecru";
    public static final String CROWD = "crowd";
    public static final String CTK_SERVER = "ctk-server";
    private static final List<String> PRODUCT_IDS = ImmutableList.of((Object)"refapp", (Object)"confluence", (Object)"jira", (Object)"bamboo", (Object)"bitbucket", (Object)"fecru", (Object)"crowd", (Object)"ctk-server");

    public static ProductHandler create(String id, MavenContext context, MavenGoals goals, RepositorySystem repositorySystem, ProjectBuilder projectBuilder, ArtifactResolver artifactResolver, WebAppManager webAppManager) {
        if (REFAPP.equals(id)) {
            return new RefappProductHandler(context, goals, repositorySystem, artifactResolver, webAppManager);
        }
        if (CONFLUENCE.equals(id)) {
            return new ConfluenceProductHandler(context, goals, repositorySystem, artifactResolver, webAppManager);
        }
        if (JIRA.equals(id)) {
            return new JiraProductHandler(context, goals, repositorySystem, artifactResolver, webAppManager);
        }
        if (BAMBOO.equals(id)) {
            return new BambooProductHandler(context, goals, repositorySystem, artifactResolver, webAppManager);
        }
        if (BITBUCKET.equals(id)) {
            return new BitbucketProductHandler(context, goals, repositorySystem, new MavenProjectLoader(), projectBuilder, artifactResolver, webAppManager);
        }
        if (FECRU.equals(id)) {
            return new FeCruProductHandler(context, goals, repositorySystem, artifactResolver);
        }
        if (CROWD.equals(id)) {
            return new CrowdProductHandler(context, goals, repositorySystem, artifactResolver, webAppManager);
        }
        if (CTK_SERVER.equals(id)) {
            return new CtkServerProductHandler(context, goals);
        }
        throw new IllegalArgumentException("Unknown product ID: '" + id + "' Valid values: " + ProductHandlerFactory.getIds());
    }

    public static Collection<String> getIds() {
        return PRODUCT_IDS;
    }

    private ProductHandlerFactory() {
        throw new UnsupportedOperationException("Not for instantiation");
    }
}

