/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.updater;

import com.atlassian.maven.plugins.updater.MpacData;
import com.atlassian.maven.plugins.updater.SdkPackageType;
import com.atlassian.maven.plugins.updater.SdkResource;
import com.atlassian.maven.plugins.updater.UpdaterException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.function.Function;
import org.apache.commons.io.IOUtils;
import org.codehaus.plexus.logging.AbstractLogEnabled;

public class MarketplaceSdkResource
extends AbstractLogEnabled
implements SdkResource {
    private static final String MARKETPLACE_API_URL_ROOT = "https://marketplace.atlassian.com/rest/1/";
    private static final String SDK_APP_KEY_PREFIX = "atlassian-plugin-sdk-";
    private final ObjectMapper mapper = new ObjectMapper();

    @Override
    public String getLatestSdkVersion(SdkPackageType packageType) {
        MpacData.Version version;
        if (!packageType.isObsolete() && (version = this.getLatestSdkVersionDetails(packageType)) != null) {
            return version.getVersionNumber();
        }
        return "";
    }

    @Override
    public File downloadSdk(SdkPackageType packageType, String version) {
        if (!packageType.isObsolete()) {
            String appSoftwareId = this.getAppSoftwareId(packageType);
            MpacData.Version sdkVersion = this.getAppSoftwareVersion(appSoftwareId, version);
            return this.downloadSdkVersion(sdkVersion, packageType, version);
        }
        return null;
    }

    @Override
    public File downloadLatestSdk(SdkPackageType packageType) {
        if (!packageType.isObsolete()) {
            String appSoftwareId = this.getAppSoftwareId(packageType);
            MpacData.Version sdkVersion = this.getAppSoftwareLatestVersion(appSoftwareId);
            return this.downloadSdkVersion(sdkVersion, packageType, "LATEST");
        }
        return null;
    }

    private File downloadSdkVersion(MpacData.Version sdkVersion, SdkPackageType packageType, String versionNum) {
        File sdkDownloadTempFile;
        if (sdkVersion == null || sdkVersion.getVersionNumber() == null || sdkVersion.getFrameworkDetails() == null || sdkVersion.getFrameworkDetails().getAttributes() == null || sdkVersion.getFrameworkDetails().getAttributes().getBinaryUrl() == null) {
            throw new UpdaterException("Couldn't find SDK version for " + packageType.key() + " on marketplace with version " + versionNum);
        }
        HttpURLConnection conn = null;
        try {
            URL url;
            sdkDownloadTempFile = File.createTempFile(SDK_APP_KEY_PREFIX + sdkVersion.getVersionNumber(), packageType.getSuffix());
            try {
                url = new URL(sdkVersion.getFrameworkDetails().getAttributes().getBinaryUrl());
            }
            catch (MalformedURLException e) {
                throw new UpdaterException(e);
            }
            conn = (HttpURLConnection)url.openConnection();
            try (InputStream inputStream = conn.getInputStream();){
                this.copyResponseStreamToFile(inputStream, sdkDownloadTempFile);
            }
        }
        catch (IOException e) {
            throw new UpdaterException(e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return sdkDownloadTempFile;
    }

    private void copyResponseStreamToFile(InputStream stream, File file) {
        try (FileOutputStream fos = new FileOutputStream(file);){
            IOUtils.copy((InputStream)stream, (OutputStream)fos);
        }
        catch (IOException ioe) {
            throw new UpdaterException(ioe);
        }
    }

    private MpacData.Version getLatestSdkVersionDetails(SdkPackageType packageType) {
        String appSoftwareId = this.getAppSoftwareId(packageType);
        return appSoftwareId != null ? this.getAppSoftwareLatestVersion(appSoftwareId) : null;
    }

    @VisibleForTesting
    String parseAppSoftwareIdResponse(String json) {
        try {
            MpacData.AppKey[] response = (MpacData.AppKey[])this.mapper.readValue(json, MpacData.AppKey[].class);
            return response.length > 0 ? response[0].getAppSoftwareId() : null;
        }
        catch (Exception e) {
            throw new UpdaterException(e);
        }
    }

    private String getAppSoftwareId(SdkPackageType packageType) {
        return this.doGetMarketplaceApi(String.format("internal/app-software/app-key/%s%s?hosting=datacenter", SDK_APP_KEY_PREFIX, packageType.key()), this::parseAppSoftwareIdResponse);
    }

    @VisibleForTesting
    MpacData.Version parseAppSoftwareLatestVersionResponse(String json) {
        try {
            MpacData.AppSoftwareVersion response = (MpacData.AppSoftwareVersion)this.mapper.readValue(json, MpacData.AppSoftwareVersion.class);
            return response.getVersions().length > 0 ? response.getVersions()[0] : null;
        }
        catch (Exception e) {
            throw new UpdaterException(e);
        }
    }

    private MpacData.Version getAppSoftwareLatestVersion(String appSoftwareId) {
        return this.doGetMarketplaceApi(String.format("app-software/%s/versions?limit=1", appSoftwareId), this::parseAppSoftwareLatestVersionResponse);
    }

    @VisibleForTesting
    MpacData.Version parseAppSoftwareVersionResponse(String json) {
        try {
            return (MpacData.Version)this.mapper.readValue(json, MpacData.Version.class);
        }
        catch (Exception e) {
            throw new UpdaterException(e);
        }
    }

    private MpacData.Version getAppSoftwareVersion(String appSoftwareId, String version) {
        return this.doGetMarketplaceApi(String.format("internal/app-software/%s/version-number/%s", appSoftwareId, version), this::parseAppSoftwareVersionResponse);
    }

    /*
     * Exception decompiling
     */
    private <T> T doGetMarketplaceApi(String uri, Function<String, T> transform) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

