/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.updater;

public enum SdkPackageType {
    WINDOWS("windows", ".exe", true, "cmd.exe", "/C"),
    MAC("mac", ".pkg", true, "open"),
    RPM("rpm", ".rpm", true, "sudo", "rpm", "-Uvh"),
    DEB("deb", ".deb", true, "sudo", "dpkg", "-i"),
    TGZ("tgz", ".tar.gz", false, new String[0]);

    private final String key;
    private final String suffix;
    private final boolean isObsolete;
    private final String[] installCommands;

    private SdkPackageType(String key, String suffix, boolean isObsolete, String ... installCommands) {
        this.key = key;
        this.suffix = suffix;
        this.isObsolete = isObsolete;
        this.installCommands = installCommands;
    }

    public String key() {
        return this.key;
    }

    public String[] installCommands() {
        return this.installCommands;
    }

    public boolean isObsolete() {
        return this.isObsolete;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public static SdkPackageType getType(String key) {
        if (key.equals("windows")) {
            return WINDOWS;
        }
        if (key.equals("mac")) {
            return MAC;
        }
        if (key.equals("rpm")) {
            return RPM;
        }
        if (key.equals("deb")) {
            return DEB;
        }
        if (key.equals("tgz")) {
            return TGZ;
        }
        return TGZ;
    }
}

