/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugin.clover;

import com.atlassian.clover.ant.groovy.GroovycSupport;
import com.atlassian.clover.cfg.instr.InstrumentationConfig;
import com.atlassian.clover.remote.DistributedConfig;
import com.atlassian.maven.plugin.clover.internal.AbstractCloverInstrumentMojo;
import com.atlassian.maven.plugin.clover.internal.CompilerConfiguration;
import com.atlassian.maven.plugin.clover.internal.instrumentation.MainInstrumenter;
import com.atlassian.maven.plugin.clover.internal.instrumentation.TestInstrumenter;
import com.atlassian.maven.plugin.clover.internal.scanner.LanguageFileExtensionFilter;
import com.atlassian.maven.plugin.clover.internal.scanner.MainSourceScanner;
import com.atlassian.maven.plugin.clover.internal.scanner.TestSourceScanner;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolverException;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResult;

@Mojo(name="instrumentInternal", defaultPhase=LifecyclePhase.VALIDATE, requiresDependencyResolution=ResolutionScope.TEST)
public class CloverInstrumentInternalMojo
extends AbstractCloverInstrumentMojo {
    public static final String CLOVER_CORE_GROUP_ID = "com.atlassian.clover";
    public static final String CLOVER_CORE_ARTIFACT_ID = "clover";
    @Parameter(defaultValue="${plugin.artifacts}", required=true)
    private List<Artifact> pluginArtifacts;
    @Parameter(defaultValue="${session}", readonly=true)
    MavenSession mavenSession;
    @Component
    ArtifactResolver artifactResolver;
    @Component
    RepositorySystem repositorySystem;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}")
    protected List<ArtifactRepository> repositories;
    private static Map<String, String> originalSrcMap = new HashMap<String, String>();
    private static Map<String, String> originalSrcTestMap = new HashMap<String, String>();

    public static String getOriginalSrcDir(String module) {
        return originalSrcMap.get(module);
    }

    public static String getOriginalSrcTestDir(String module) {
        return originalSrcTestMap.get(module);
    }

    @Override
    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping clover instrumentation.");
            return;
        }
        super.execute();
        this.configureTestFailureIgnore();
        CloverInstrumentInternalMojo.resetSrcDirsOriginal(this.getProject().getArtifact(), this);
        File outDir = new File(this.cloverOutputDirectory, this.getSrcName());
        String cloverOutputSourceDirectory = outDir.getPath();
        String cloverOutputTestSourceDirectory = new File(this.cloverOutputDirectory, this.getSrcTestName()).getPath();
        new File(this.resolveCloverDatabase()).getParentFile().mkdirs();
        this.logArtifacts("before changes");
        MainInstrumenter mainInstrumenter = new MainInstrumenter(this, cloverOutputSourceDirectory);
        TestInstrumenter testInstrumenter = new TestInstrumenter(this, cloverOutputTestSourceDirectory);
        if (this.isJavaProject()) {
            mainInstrumenter.instrument();
            if (this.includesTestSourceRoots) {
                testInstrumenter.instrument();
            }
        }
        this.addCloverDependencyToCompileClasspath();
        this.swizzleCloverDependencies();
        String originalSrcDir = mainInstrumenter.redirectSourceDirectories();
        originalSrcMap.put(this.getProject().getArtifact().getId(), originalSrcDir);
        if (this.includesTestSourceRoots) {
            String originalSrcTestDir = testInstrumenter.redirectSourceDirectories();
            originalSrcTestMap.put(this.getProject().getArtifact().getId(), originalSrcTestDir);
        }
        this.injectGrover(outDir);
        this.redirectOutputDirectories();
        this.redirectArtifact();
        this.logArtifacts("after changes");
    }

    @Override
    protected boolean shouldRedirectArtifacts() {
        return true;
    }

    @Override
    protected boolean shouldRedirectOutputDirectories() {
        return true;
    }

    private void configureTestFailureIgnore() {
        if (this.setTestFailureIgnore) {
            this.getLog().debug((CharSequence)"Configuring testFailureIgnore=true and failOnViolation=false");
            Properties properties = this.getProject().getProperties();
            properties.put("maven.test.failure.ignore", "true");
            properties.put("checkstyle.failOnViolation", "false");
            properties.put("pmd.failOnViolation", "false");
        }
    }

    private void injectGrover(File outDir) {
        if (this.skipGroverJar) {
            this.getLog().info((CharSequence)"Generation of Clover Groovy configuration is disabled. No Groovy instrumentation will occur.");
            return;
        }
        InstrumentationConfig config = new InstrumentationConfig();
        config.setProjectName(this.getProject().getName());
        config.setInitstring(this.resolveCloverDatabase());
        config.setTmpDir(outDir);
        List<File> includeFiles = this.calcIncludedFilesForGroovy();
        this.getLog().debug((CharSequence)("Clover including the following files for Groovy instrumentation: " + includeFiles));
        config.setIncludedFiles(includeFiles);
        config.setEnabled(true);
        config.setEncoding(this.getEncoding());
        config.setDistributedConfig(this.getDistributedCoverage() == null ? null : new DistributedConfig(this.getDistributedCoverage().getConfigString()));
        try {
            File groverJar = GroovycSupport.extractGroverJar((File)this.groverJar, (boolean)false);
            File groverConfigDir = GroovycSupport.newConfigDir((InstrumentationConfig)config, (File)new File(this.getProject().getBuild().getOutputDirectory()));
            Resource groverConfigResource = new Resource();
            groverConfigResource.setDirectory(groverConfigDir.getPath());
            this.getProject().addResource(groverConfigResource);
            Artifact cloverArtifact = this.findCloverArtifact(this.pluginArtifacts);
            Artifact groverArtifact = this.repositorySystem.createArtifact(cloverArtifact.getGroupId(), "grover", cloverArtifact.getVersion(), "system", "jar");
            groverArtifact.setFile(groverJar);
            this.addArtifactDependency(groverArtifact);
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)("Could not create Clover Groovy configuration file. No Groovy instrumentation will occur. " + e.getMessage()), (Throwable)e);
        }
    }

    protected List<File> calcIncludedFilesForGroovy() {
        MainSourceScanner groovyMainScanner = new MainSourceScanner(this, this.getProject().getBuild().getOutputDirectory());
        ArrayList<File> mainGroovyFiles = this.extractIncludes(groovyMainScanner.getSourceFilesToInstrument(LanguageFileExtensionFilter.GROOVY_LANGUAGE, false));
        TestSourceScanner groovyTestScanner = new TestSourceScanner(this, this.getProject().getBuild().getOutputDirectory());
        ArrayList<File> testGroovyFiles = this.extractIncludes(groovyTestScanner.getSourceFilesToInstrument(LanguageFileExtensionFilter.GROOVY_LANGUAGE, false));
        ArrayList<File> allSources = new ArrayList<File>(mainGroovyFiles);
        allSources.addAll(testGroovyFiles);
        return allSources;
    }

    private ArrayList<File> extractIncludes(Map<String, String[]> srcFiles) {
        ArrayList<File> includeFiles = new ArrayList<File>();
        for (String dirName : srcFiles.keySet()) {
            String[] includes;
            for (String include : includes = srcFiles.get(dirName)) {
                includeFiles.add(new File(dirName, include));
            }
        }
        return includeFiles;
    }

    public static void resetSrcDirsOriginal(Artifact artifact, CompilerConfiguration config) {
        if (originalSrcMap.containsKey(artifact.getId())) {
            String sourceDirectory = originalSrcMap.get(artifact.getId());
            MainInstrumenter mainInstrumenter = new MainInstrumenter(config, sourceDirectory);
            mainInstrumenter.redirectSourceDirectories();
        }
        if (originalSrcTestMap.containsKey(artifact.getId())) {
            String testDirectory = originalSrcTestMap.get(artifact.getId());
            TestInstrumenter instrumenter = new TestInstrumenter(config, testDirectory);
            instrumenter.redirectSourceDirectories();
        }
    }

    protected String getSrcTestName() {
        return "src-test";
    }

    protected String getSrcName() {
        return "src";
    }

    private boolean isJavaProject() {
        ArtifactHandler artifactHandler = this.getProject().getArtifact().getArtifactHandler();
        if (!"java".equals(artifactHandler.getLanguage())) {
            this.getLog().debug((CharSequence)("The reported language of this project is " + artifactHandler.getLanguage() + ", attempting to instrument sources anyway."));
        }
        return true;
    }

    protected void redirectOutputDirectories() {
        if (this.shouldRedirectOutputDirectories()) {
            this.getProject().getBuild().setDirectory(this.cloverOutputDirectory);
            this.getProject().getBuild().setOutputDirectory(new File(this.cloverOutputDirectory, "classes").getPath());
            this.getProject().getBuild().setTestOutputDirectory(new File(this.cloverOutputDirectory, "test-classes").getPath());
        }
    }

    protected void redirectArtifact() {
        if (this.shouldRedirectArtifacts() && !this.getProject().getPackaging().equals("pom")) {
            Artifact oldArtifact = this.getProject().getArtifact();
            Artifact newArtifact = this.repositorySystem.createArtifactWithClassifier(oldArtifact.getGroupId(), oldArtifact.getArtifactId(), oldArtifact.getVersion(), oldArtifact.getType(), CLOVER_CORE_ARTIFACT_ID);
            this.getProject().setArtifact(newArtifact);
            String finalName = this.getProject().getBuild().getFinalName() == null ? this.getProject().getArtifactId() + "-" + this.getProject().getVersion() : this.getProject().getBuild().getFinalName();
            this.getProject().getBuild().setFinalName(finalName + (this.useCloverClassifier ? "-clover" : ""));
        }
    }

    private void swizzleCloverDependencies() {
        Set<Artifact> swizzledDependencyArtifacts = this.swizzleCloverDependencies(this.getProject().getDependencyArtifacts());
        Set artifacts = this.getProject().getArtifacts();
        Set dependencyArtifacts = this.getProject().getDependencyArtifacts();
        artifacts.removeAll(dependencyArtifacts);
        Set<Artifact> swizzledArtifacts = this.swizzleCloverDependencies(artifacts);
        swizzledArtifacts.addAll(swizzledDependencyArtifacts);
        this.getProject().setDependencyArtifacts(swizzledDependencyArtifacts);
        this.getProject().setArtifacts(swizzledArtifacts);
    }

    protected Set<Artifact> swizzleCloverDependencies(Set<Artifact> artifacts) {
        LinkedHashSet<Artifact> resolvedArtifacts = new LinkedHashSet<Artifact>();
        for (Artifact artifact : artifacts) {
            resolvedArtifacts.add(this.swizzleCloverDependency(artifact));
        }
        return resolvedArtifacts;
    }

    private Artifact swizzleCloverDependency(Artifact artifact) {
        Artifact resolvedCloveredArtifact;
        if (artifact.hasClassifier()) {
            this.getLog().debug((CharSequence)("Skipped dependency [" + artifact.getId() + "] as it has a classifier"));
            return artifact;
        }
        Artifact cloveredArtifact = this.repositorySystem.createArtifactWithClassifier(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getType(), CLOVER_CORE_ARTIFACT_ID);
        cloveredArtifact.setScope(artifact.getScope());
        try {
            DefaultProjectBuildingRequest projectBuildingRequest = new DefaultProjectBuildingRequest(this.mavenSession.getProjectBuildingRequest());
            projectBuildingRequest.setRemoteRepositories(null);
            ArtifactResult resolveResult = this.artifactResolver.resolveArtifact((ProjectBuildingRequest)projectBuildingRequest, cloveredArtifact);
            resolvedCloveredArtifact = resolveResult.getArtifact();
            resolvedCloveredArtifact.setScope(artifact.getScope());
        }
        catch (ArtifactResolverException e) {
            this.getLog().debug((CharSequence)("Skipped dependency [" + cloveredArtifact.getId() + "] as it is unresolved"), (Throwable)e);
            return artifact;
        }
        if (resolvedCloveredArtifact.getFile().lastModified() + this.cloveredArtifactExpiryInMillis < artifact.getFile().lastModified()) {
            this.getLog().warn((CharSequence)("Using [" + artifact.getId() + "], built on " + new Date(artifact.getFile().lastModified()) + " even though a Clovered version exists but it's older (lastModified: " + new Date(resolvedCloveredArtifact.getFile().lastModified()) + " ) and could fail the build. Please consider running Clover again on that dependency's project."));
            return artifact;
        }
        return resolvedCloveredArtifact;
    }

    protected Artifact findCloverArtifact(List<Artifact> pluginArtifacts) {
        Artifact cloverArtifact = null;
        Iterator<Artifact> artifactsIterator = pluginArtifacts.iterator();
        while (artifactsIterator.hasNext() && cloverArtifact == null) {
            Artifact artifact = artifactsIterator.next();
            if (!CLOVER_CORE_GROUP_ID.equals(artifact.getGroupId()) || !CLOVER_CORE_ARTIFACT_ID.equals(artifact.getArtifactId())) continue;
            cloverArtifact = artifact;
        }
        return cloverArtifact;
    }

    private void addCloverDependencyToCompileClasspath() throws MojoExecutionException {
        Artifact cloverArtifact = this.findCloverArtifact(this.pluginArtifacts);
        if (cloverArtifact == null) {
            throw new MojoExecutionException("Couldn't find [com.atlassian.clover:clover] artifact in plugin dependencies");
        }
        String jarScope = this.scope == null ? "provided" : this.scope;
        cloverArtifact = this.repositorySystem.createArtifact(cloverArtifact.getGroupId(), cloverArtifact.getArtifactId(), cloverArtifact.getVersion(), jarScope, cloverArtifact.getType());
        try {
            this.artifactResolver.resolveArtifact(this.mavenSession.getProjectBuildingRequest(), cloverArtifact);
            this.addArtifactDependency(cloverArtifact);
        }
        catch (ArtifactResolverException ex) {
            throw new MojoExecutionException("Could not resolve the clover artifact ( " + cloverArtifact.getId(), (Exception)((Object)ex));
        }
    }

    private void addArtifactDependency(Artifact cloverArtifact) {
        LinkedHashSet<Artifact> set = new LinkedHashSet<Artifact>(this.getProject().getDependencyArtifacts());
        set.add(cloverArtifact);
        this.getProject().setDependencyArtifacts(set);
    }

    private void logArtifacts(String message) {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("[Clover] List of dependency artifacts " + message + ":"));
            this.logArtifacts(this.getProject().getDependencyArtifacts());
            this.getLog().debug((CharSequence)("[Clover] List of artifacts " + message + ":"));
            this.logArtifacts(this.getProject().getArtifacts());
        }
    }

    private void logArtifacts(Set<Artifact> artifacts) {
        for (Artifact artifact : artifacts) {
            this.getLog().debug((CharSequence)("[Clover]   Artifact [" + artifact.getId() + "], scope = [" + artifact.getScope() + "]"));
        }
    }
}

