/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugin.clover;

import com.atlassian.clover.ant.tasks.CloverMergeTask;
import com.atlassian.clover.cfg.Interval;
import com.atlassian.maven.plugin.clover.internal.AbstractCloverMojo;
import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;

@Mojo(name="merge")
public class CloverMergeMojo
extends AbstractCloverMojo {
    @Parameter(property="maven.clover.merge.basedir", required=true)
    private File baseDir;
    @Parameter(property="maven.clover.merge.includes", defaultValue="*.db")
    private String includes;
    @Parameter(property="maven.clover.merge.span")
    private String span;

    @Override
    public void execute() throws MojoExecutionException {
        AbstractCloverMojo.waitForFlush(this.getWaitForFlush(), this.getFlushInterval());
        this.mergeCloverDatabases();
    }

    private void mergeCloverDatabases() throws MojoExecutionException {
        try {
            Project antProject = new Project();
            antProject.init();
            CloverMergeTask merge = new CloverMergeTask();
            merge.setProject(antProject);
            merge.init();
            merge.setInitString(this.getCloverMergeDatabase());
            CloverMergeTask.CloverDbSet dbSet = new CloverMergeTask.CloverDbSet();
            dbSet.setProject(antProject);
            dbSet.setIncludes(this.includes);
            dbSet.setDir(this.baseDir);
            if (this.span != null) {
                dbSet.setSpan(new Interval(this.span));
            }
            merge.addCloverDbSet(dbSet);
            merge.execute();
        }
        catch (BuildException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }
}

