/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugin.clover;

import com.atlassian.clover.Logger;
import com.atlassian.clover.ant.tasks.CloverSnapshotTask;
import com.atlassian.clover.optimization.Snapshot;
import com.atlassian.clover.optimization.SnapshotPrinter;
import com.atlassian.maven.plugin.clover.CloverSetupMojo;
import com.atlassian.maven.plugin.clover.MvnLogBuildListener;
import com.atlassian.maven.plugin.clover.MvnLogger;
import com.atlassian.maven.plugin.clover.internal.AbstractCloverMojo;
import com.atlassian.maven.plugin.clover.internal.ConfigUtil;
import java.io.File;
import java.util.Date;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;

@Mojo(name="snapshot", defaultPhase=LifecyclePhase.TEST)
public class CloverSnapshotMojo
extends AbstractCloverMojo {
    @Parameter(property="maven.clover.span")
    private String span;
    @Parameter(property="maven.clover.forceSnapshot", defaultValue="false")
    private boolean forceSnapshot;

    @Override
    public void execute() throws MojoExecutionException {
        if (this.isSingleCloverDatabase() && !this.isLastProjectInReactor() && !this.forceSnapshot) {
            this.getLog().info((CharSequence)"Skipping snapshot until the final project in the reactor.");
            return;
        }
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping snapshot.");
            return;
        }
        if (!new File(this.resolveCloverDatabase()).exists()) {
            this.getLog().info((CharSequence)(this.resolveCloverDatabase() + " does not exist. Skipping snapshot creation."));
            return;
        }
        CloverSnapshotTask task = this.createSnapshotTask();
        task.setInitString(this.resolveCloverDatabase());
        task.setDebug(this.debug);
        if (this.span != null) {
            task.setSpan(this.span);
        } else if (CloverSetupMojo.START_DATE != null) {
            long timeSinceStart = new Date().getTime() - CloverSetupMojo.START_DATE.getTime();
            String interval = (timeSinceStart + 1000L) / 1000L + "s";
            this.getLog().info((CharSequence)("No span specified, using span of: " + interval));
            task.setSpan(interval);
        }
        this.snapshot = new ConfigUtil(this).resolveSnapshotFile(this.snapshot);
        this.snapshot.getParentFile().mkdirs();
        this.getLog().info((CharSequence)("Saving snapshot to: " + this.snapshot));
        task.setFile(this.snapshot);
        this.execTask(task);
        if (this.getLog().isDebugEnabled() || this.debug) {
            String cpLocation = this.snapshot != null ? this.snapshot.getPath() : task.getInitString() + ".snapshot";
            SnapshotPrinter.textPrint((Snapshot)Snapshot.loadFrom((String)cpLocation), (Logger)new MvnLogger(this.getLog()), (int)3);
        }
    }

    protected void execTask(CloverSnapshotTask task) {
        task.execute();
    }

    CloverSnapshotTask createSnapshotTask() {
        CloverSnapshotTask task = new CloverSnapshotTask();
        Project antProj = new Project();
        antProj.init();
        antProj.addBuildListener((BuildListener)new MvnLogBuildListener(this.getLog()));
        task.setProject(antProj);
        task.init();
        return task;
    }
}

