/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugin.clover.internal.lifecycle;

import com.atlassian.clover.api.CloverException;
import com.atlassian.maven.plugin.clover.internal.lifecycle.Maven3LifecycleAnalyzer;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.LifecycleExecutor;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.jetbrains.annotations.NotNull;

public class BuildLifecycleAnalyzer {
    private final Log log;
    private final LifecycleExecutor lifecycleExecutor;
    private final MavenProject mavenProject;
    private final MavenSession mavenSession;
    private final Set<String> phases;

    public BuildLifecycleAnalyzer(@NotNull Log log, @NotNull LifecycleExecutor lifecycleExecutor, @NotNull MavenProject mavenProject, @NotNull MavenSession mavenSession) {
        this.log = log;
        this.lifecycleExecutor = lifecycleExecutor;
        this.mavenProject = mavenProject;
        this.mavenSession = mavenSession;
        this.phases = this.getPhasesToBeExecuted();
        log.debug((CharSequence)("CLOVER: " + this.getClass().getSimpleName() + " found following build phases:"));
        for (String phase : new TreeSet<String>(this.phases)) {
            log.debug((CharSequence)("CLOVER: " + phase));
        }
    }

    public boolean isInstallPresent() {
        return this.phases.contains("install");
    }

    public boolean isDeployPresent() {
        return this.phases.contains("deploy");
    }

    @NotNull
    protected Set<String> getPhasesToBeExecuted() {
        String FAILED_POLLUTION_PROTECTION = "CLOVER: Failed to call Maven's internals via reflections, possibly this Maven version is incompatible with Clover. Maven's build lifecycle could not be analyzed. Repository pollution protection will not run. ";
        try {
            Maven3LifecycleAnalyzer maven3Analyzer = new Maven3LifecycleAnalyzer(this.lifecycleExecutor, this.mavenProject, this.mavenSession);
            if (maven3Analyzer.isCompatibleVersion()) {
                return maven3Analyzer.getPhasesToBeExecuted();
            }
            this.log.warn((CharSequence)"CLOVER: Failed to call Maven's internals via reflections, possibly this Maven version is incompatible with Clover. Maven's build lifecycle could not be analyzed. Repository pollution protection will not run. ");
            return Collections.emptySet();
        }
        catch (CloverException ex) {
            this.log.warn((CharSequence)"CLOVER: Failed to call Maven's internals via reflections, possibly this Maven version is incompatible with Clover. Maven's build lifecycle could not be analyzed. Repository pollution protection will not run. ");
            return Collections.emptySet();
        }
    }
}

