/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.jira;

import com.atlassian.maven.plugins.amps.IntegrationTestMojo;
import com.atlassian.maven.plugins.amps.Product;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="integration-test", requiresDependencyResolution=ResolutionScope.TEST)
public class JiraIntegrationTestMojo
extends IntegrationTestMojo {
    protected String getDefaultProductId() {
        return "jira";
    }

    protected Map<String, String> getProductFunctionalTestProperties(Product product) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("jira.protocol", product.getProtocol());
        props.put("jira.host", product.getServer());
        props.put("jira.xml.data.location", this.getMavenContext().getProject().getBasedir() + "/src/test/xml");
        props.put("jira.context", product.getContextPath());
        props.put("jira.port", String.valueOf(product.getWebPortForNode(0)));
        for (int i = 0; i < product.getNodes().size(); ++i) {
            props.put("jira.port." + i, String.valueOf(product.getWebPortForNode(i)));
        }
        this.getLog().info((CharSequence)("jira props: " + props));
        return props;
    }
}

