/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product;

import com.atlassian.maven.plugins.amps.MavenContext;
import com.atlassian.maven.plugins.amps.MavenGoals;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.product.AbstractPluginProvider;
import com.atlassian.maven.plugins.amps.product.AbstractWebappProductHandler;
import com.atlassian.maven.plugins.amps.util.ConfigFileUtils;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.plugin.MojoExecutionException;

public class StashProductHandler
extends AbstractWebappProductHandler {
    public StashProductHandler(MavenContext context, MavenGoals goals, ArtifactFactory artifactFactory) {
        super(context, goals, new StashPluginProvider(), artifactFactory);
    }

    @Override
    public void cleanupProductHomeForZip(Product product, File snapshotDir) throws MojoExecutionException, IOException {
        super.cleanupProductHomeForZip(product, snapshotDir);
        FileUtils.deleteQuietly((File)new File(snapshotDir, "log/atlassian-stash.log"));
        FileUtils.deleteQuietly((File)new File(snapshotDir, ".osgi-cache"));
    }

    @Override
    public String getId() {
        return "stash";
    }

    @Override
    public ProductArtifact getArtifact() {
        return new ProductArtifact("com.atlassian.stash", "stash-webapp");
    }

    @Override
    public File getBundledPluginPath(Product ctx, File appDir) {
        String bundledPluginPluginsPath = "WEB-INF/classes/stash-bundled-plugins.zip";
        return new File(appDir, bundledPluginPluginsPath);
    }

    @Override
    public List<File> getConfigFiles(Product product, File homeDir) {
        List<File> configFiles = super.getConfigFiles(product, homeDir);
        configFiles.add(new File(homeDir, "data/db.log"));
        configFiles.add(new File(homeDir, "data/db.script"));
        configFiles.add(new File(homeDir, "data/db.properties"));
        configFiles.add(new File(homeDir, "shared/data/db.log"));
        configFiles.add(new File(homeDir, "shared/data/db.script"));
        configFiles.add(new File(homeDir, "shared/data/db.properties"));
        return configFiles;
    }

    public List<ProductArtifact> getDefaultBundledPlugins() {
        return Collections.emptyList();
    }

    @Override
    public String getDefaultContainerId() {
        return "tomcat8x";
    }

    @Override
    public int getDefaultHttpPort() {
        return 7990;
    }

    @Override
    public int getDefaultHttpsPort() {
        return 8447;
    }

    public List<ProductArtifact> getDefaultLibPlugins() {
        return Collections.emptyList();
    }

    @Override
    public List<ProductArtifact> getExtraContainerDependencies() {
        return Collections.emptyList();
    }

    @Override
    public List<ConfigFileUtils.Replacement> getReplacements(Product ctx) {
        return super.getReplacements(ctx);
    }

    @Override
    public Map<String, String> getSystemProperties(Product ctx) {
        String baseUrl = MavenGoals.getBaseUrl(ctx, ctx.getHttpPort());
        return ImmutableMap.builder().putAll(super.getSystemProperties(ctx)).put((Object)"baseurl", (Object)baseUrl).put((Object)"baseurl.display", (Object)baseUrl).put((Object)"cargo.servlet.uriencoding", (Object)"UTF-8").put((Object)"johnson.spring.lifecycle.synchronousStartup", (Object)Boolean.TRUE.toString()).put((Object)"stash.home", (Object)StashProductHandler.fixSlashes(this.getHomeDirectory(ctx).getPath())).build();
    }

    @Override
    public ProductArtifact getTestResourcesArtifact() {
        return new ProductArtifact("com.atlassian.stash", "stash-plugin-test-resources");
    }

    @Override
    public File getUserInstalledPluginsDirectory(Product product, File webappDir, File homeDir) {
        File baseDir = homeDir;
        File sharedHomeDir = new File(homeDir, "shared");
        if (sharedHomeDir.exists()) {
            baseDir = sharedHomeDir;
        }
        return new File(new File(baseDir, "plugins"), "installed-plugins");
    }

    private static String fixSlashes(String path) {
        return path.replaceAll("\\\\", "/");
    }

    private static class StashPluginProvider
    extends AbstractPluginProvider {
        private StashPluginProvider() {
        }

        @Override
        protected Collection<ProductArtifact> getSalArtifacts(String salVersion) {
            return Collections.emptyList();
        }
    }
}

